/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDiscoveredResourcesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListDiscoveredResourcesRequest.Builder, ListDiscoveredResourcesRequest> {
    private final String resourceType;

    private final List<String> resourceIds;

    private final String resourceName;

    private final Integer limit;

    private final Boolean includeDeletedResources;

    private final String nextToken;

    private ListDiscoveredResourcesRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceIds = builder.resourceIds;
        this.resourceName = builder.resourceName;
        this.limit = builder.limit;
        this.includeDeletedResources = builder.includeDeletedResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The type of resources that you want AWS Config to list in the response.
     * </p>
     * 
     * @return The type of resources that you want AWS Config to list in the response.
     * @see ResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The IDs of only those resources that you want AWS Config to list in the response. If you do not specify this
     * parameter, AWS Config lists all resources of the specified type that it has discovered.
     * </p>
     * 
     * @return The IDs of only those resources that you want AWS Config to list in the response. If you do not specify
     *         this parameter, AWS Config lists all resources of the specified type that it has discovered.
     */
    public List<String> resourceIds() {
        return resourceIds;
    }

    /**
     * <p>
     * The custom name of only those resources that you want AWS Config to list in the response. If you do not specify
     * this parameter, AWS Config lists all resources of the specified type that it has discovered.
     * </p>
     * 
     * @return The custom name of only those resources that you want AWS Config to list in the response. If you do not
     *         specify this parameter, AWS Config lists all resources of the specified type that it has discovered.
     */
    public String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a limit
     * greater than 100. If you specify 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify
     *         a limit greater than 100. If you specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Specifies whether AWS Config includes deleted resources in the results. By default, deleted resources are not
     * included.
     * </p>
     * 
     * @return Specifies whether AWS Config includes deleted resources in the results. By default, deleted resources are
     *         not included.
     */
    public Boolean includeDeletedResources() {
        return includeDeletedResources;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((resourceIds() == null) ? 0 : resourceIds().hashCode());
        hashCode = 31 * hashCode + ((resourceName() == null) ? 0 : resourceName().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((includeDeletedResources() == null) ? 0 : includeDeletedResources().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesRequest)) {
            return false;
        }
        ListDiscoveredResourcesRequest other = (ListDiscoveredResourcesRequest) obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceIds() == null ^ this.resourceIds() == null) {
            return false;
        }
        if (other.resourceIds() != null && !other.resourceIds().equals(this.resourceIds())) {
            return false;
        }
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.includeDeletedResources() == null ^ this.includeDeletedResources() == null) {
            return false;
        }
        if (other.includeDeletedResources() != null && !other.includeDeletedResources().equals(this.includeDeletedResources())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (resourceIds() != null) {
            sb.append("ResourceIds: ").append(resourceIds()).append(",");
        }
        if (resourceName() != null) {
            sb.append("ResourceName: ").append(resourceName()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (includeDeletedResources() != null) {
            sb.append("IncludeDeletedResources: ").append(includeDeletedResources()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDiscoveredResourcesRequest> {
        /**
         * <p>
         * The type of resources that you want AWS Config to list in the response.
         * </p>
         * 
         * @param resourceType
         *        The type of resources that you want AWS Config to list in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resources that you want AWS Config to list in the response.
         * </p>
         * 
         * @param resourceType
         *        The type of resources that you want AWS Config to list in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The IDs of only those resources that you want AWS Config to list in the response. If you do not specify this
         * parameter, AWS Config lists all resources of the specified type that it has discovered.
         * </p>
         * 
         * @param resourceIds
         *        The IDs of only those resources that you want AWS Config to list in the response. If you do not
         *        specify this parameter, AWS Config lists all resources of the specified type that it has discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * The IDs of only those resources that you want AWS Config to list in the response. If you do not specify this
         * parameter, AWS Config lists all resources of the specified type that it has discovered.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setResourceIds(java.util.Collection)} or {@link #withResourceIds(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param resourceIds
         *        The IDs of only those resources that you want AWS Config to list in the response. If you do not
         *        specify this parameter, AWS Config lists all resources of the specified type that it has discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);

        /**
         * <p>
         * The custom name of only those resources that you want AWS Config to list in the response. If you do not
         * specify this parameter, AWS Config lists all resources of the specified type that it has discovered.
         * </p>
         * 
         * @param resourceName
         *        The custom name of only those resources that you want AWS Config to list in the response. If you do
         *        not specify this parameter, AWS Config lists all resources of the specified type that it has
         *        discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a
         * limit greater than 100. If you specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of resource identifiers returned on each page. The default is 100. You cannot
         *        specify a limit greater than 100. If you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Specifies whether AWS Config includes deleted resources in the results. By default, deleted resources are not
         * included.
         * </p>
         * 
         * @param includeDeletedResources
         *        Specifies whether AWS Config includes deleted resources in the results. By default, deleted resources
         *        are not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDeletedResources(Boolean includeDeletedResources);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceType;

        private List<String> resourceIds = new SdkInternalList<>();

        private String resourceName;

        private Integer limit;

        private Boolean includeDeletedResources;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesRequest model) {
            setResourceType(model.resourceType);
            setResourceIds(model.resourceIds);
            setResourceName(model.resourceName);
            setLimit(model.limit);
            setIncludeDeletedResources(model.includeDeletedResources);
            setNextToken(model.nextToken);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final Collection<String> getResourceIds() {
            return resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            if (this.resourceIds == null) {
                this.resourceIds = new SdkInternalList<>(resourceIds.length);
            }
            for (String e : resourceIds) {
                this.resourceIds.add(e);
            }
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdListCopier.copy(resourceIds);
        }

        @SafeVarargs
        public final void setResourceIds(String... resourceIds) {
            if (this.resourceIds == null) {
                this.resourceIds = new SdkInternalList<>(resourceIds.length);
            }
            for (String e : resourceIds) {
                this.resourceIds.add(e);
            }
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getIncludeDeletedResources() {
            return includeDeletedResources;
        }

        @Override
        public final Builder includeDeletedResources(Boolean includeDeletedResources) {
            this.includeDeletedResources = includeDeletedResources;
            return this;
        }

        public final void setIncludeDeletedResources(Boolean includeDeletedResources) {
            this.includeDeletedResources = includeDeletedResources;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDiscoveredResourcesRequest build() {
            return new ListDiscoveredResourcesRequest(this);
        }
    }
}
