/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDiscoveredResourcesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDiscoveredResourcesResponse.Builder, ListDiscoveredResourcesResponse> {
    private final List<ResourceIdentifier> resourceIdentifiers;

    private final String nextToken;

    private ListDiscoveredResourcesResponse(BuilderImpl builder) {
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The details that identify a resource that is discovered by AWS Config, including the resource type, ID, and (if
     * available) the custom resource name.
     * </p>
     * 
     * @return The details that identify a resource that is discovered by AWS Config, including the resource type, ID,
     *         and (if available) the custom resource name.
     */
    public List<ResourceIdentifier> resourceIdentifiers() {
        return resourceIdentifiers;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceIdentifiers() == null) ? 0 : resourceIdentifiers().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesResponse)) {
            return false;
        }
        ListDiscoveredResourcesResponse other = (ListDiscoveredResourcesResponse) obj;
        if (other.resourceIdentifiers() == null ^ this.resourceIdentifiers() == null) {
            return false;
        }
        if (other.resourceIdentifiers() != null && !other.resourceIdentifiers().equals(this.resourceIdentifiers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceIdentifiers() != null) {
            sb.append("ResourceIdentifiers: ").append(resourceIdentifiers()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDiscoveredResourcesResponse> {
        /**
         * <p>
         * The details that identify a resource that is discovered by AWS Config, including the resource type, ID, and
         * (if available) the custom resource name.
         * </p>
         * 
         * @param resourceIdentifiers
         *        The details that identify a resource that is discovered by AWS Config, including the resource type,
         *        ID, and (if available) the custom resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers);

        /**
         * <p>
         * The details that identify a resource that is discovered by AWS Config, including the resource type, ID, and
         * (if available) the custom resource name.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setResourceIdentifiers(java.util.Collection)} or
         * {@link #withResourceIdentifiers(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param resourceIdentifiers
         *        The details that identify a resource that is discovered by AWS Config, including the resource type,
         *        ID, and (if available) the custom resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(ResourceIdentifier... resourceIdentifiers);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ResourceIdentifier> resourceIdentifiers = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesResponse model) {
            setResourceIdentifiers(model.resourceIdentifiers);
            setNextToken(model.nextToken);
        }

        public final Collection<ResourceIdentifier> getResourceIdentifiers() {
            return resourceIdentifiers;
        }

        @Override
        public final Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(ResourceIdentifier... resourceIdentifiers) {
            if (this.resourceIdentifiers == null) {
                this.resourceIdentifiers = new SdkInternalList<>(resourceIdentifiers.length);
            }
            for (ResourceIdentifier e : resourceIdentifiers) {
                this.resourceIdentifiers.add(e);
            }
            return this;
        }

        public final void setResourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copy(resourceIdentifiers);
        }

        @SafeVarargs
        public final void setResourceIdentifiers(ResourceIdentifier... resourceIdentifiers) {
            if (this.resourceIdentifiers == null) {
                this.resourceIdentifiers = new SdkInternalList<>(resourceIdentifiers.length);
            }
            for (ResourceIdentifier e : resourceIdentifiers) {
                this.resourceIdentifiers.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDiscoveredResourcesResponse build() {
            return new ListDiscoveredResourcesResponse(this);
        }
    }
}
