/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.RelationshipMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The relationship of the related resource to the main resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Relationship implements StructuredPojo, ToCopyableBuilder<Relationship.Builder, Relationship> {
    private final String resourceType;

    private final String resourceId;

    private final String resourceName;

    private final String relationshipName;

    private Relationship(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.relationshipName = builder.relationshipName;
    }

    /**
     * <p>
     * The resource type of the related resource.
     * </p>
     * 
     * @return The resource type of the related resource.
     * @see ResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the related resource (for example, <code>sg-xxxxxx</code>).
     * </p>
     * 
     * @return The ID of the related resource (for example, <code>sg-xxxxxx</code>).
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The custom name of the related resource, if available.
     * </p>
     * 
     * @return The custom name of the related resource, if available.
     */
    public String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The type of relationship with the related resource.
     * </p>
     * 
     * @return The type of relationship with the related resource.
     */
    public String relationshipName() {
        return relationshipName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        hashCode = 31 * hashCode + ((resourceName() == null) ? 0 : resourceName().hashCode());
        hashCode = 31 * hashCode + ((relationshipName() == null) ? 0 : relationshipName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship) obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.relationshipName() == null ^ this.relationshipName() == null) {
            return false;
        }
        if (other.relationshipName() != null && !other.relationshipName().equals(this.relationshipName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (resourceName() != null) {
            sb.append("ResourceName: ").append(resourceName()).append(",");
        }
        if (relationshipName() != null) {
            sb.append("RelationshipName: ").append(relationshipName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RelationshipMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Relationship> {
        /**
         * <p>
         * The resource type of the related resource.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the related resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type of the related resource.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the related resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The ID of the related resource (for example, <code>sg-xxxxxx</code>).
         * </p>
         * 
         * @param resourceId
         *        The ID of the related resource (for example, <code>sg-xxxxxx</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The custom name of the related resource, if available.
         * </p>
         * 
         * @param resourceName
         *        The custom name of the related resource, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The type of relationship with the related resource.
         * </p>
         * 
         * @param relationshipName
         *        The type of relationship with the related resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationshipName(String relationshipName);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private String resourceName;

        private String relationshipName;

        private BuilderImpl() {
        }

        private BuilderImpl(Relationship model) {
            setResourceType(model.resourceType);
            setResourceId(model.resourceId);
            setResourceName(model.resourceName);
            setRelationshipName(model.relationshipName);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getRelationshipName() {
            return relationshipName;
        }

        @Override
        public final Builder relationshipName(String relationshipName) {
            this.relationshipName = relationshipName;
            return this;
        }

        public final void setRelationshipName(String relationshipName) {
            this.relationshipName = relationshipName;
        }

        @Override
        public Relationship build() {
            return new Relationship(this);
        }
    }
}
