/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class StartConfigRulesEvaluationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<StartConfigRulesEvaluationRequest.Builder, StartConfigRulesEvaluationRequest> {
    private final List<String> configRuleNames;

    private StartConfigRulesEvaluationRequest(BuilderImpl builder) {
        this.configRuleNames = builder.configRuleNames;
    }

    /**
     * <p>
     * The list of names of Config rules that you want to run evaluations for.
     * </p>
     * 
     * @return The list of names of Config rules that you want to run evaluations for.
     */
    public List<String> configRuleNames() {
        return configRuleNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configRuleNames() == null) ? 0 : configRuleNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigRulesEvaluationRequest)) {
            return false;
        }
        StartConfigRulesEvaluationRequest other = (StartConfigRulesEvaluationRequest) obj;
        if (other.configRuleNames() == null ^ this.configRuleNames() == null) {
            return false;
        }
        if (other.configRuleNames() != null && !other.configRuleNames().equals(this.configRuleNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configRuleNames() != null) {
            sb.append("ConfigRuleNames: ").append(configRuleNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StartConfigRulesEvaluationRequest> {
        /**
         * <p>
         * The list of names of Config rules that you want to run evaluations for.
         * </p>
         * 
         * @param configRuleNames
         *        The list of names of Config rules that you want to run evaluations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(Collection<String> configRuleNames);

        /**
         * <p>
         * The list of names of Config rules that you want to run evaluations for.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setConfigRuleNames(java.util.Collection)} or {@link #withConfigRuleNames(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param configRuleNames
         *        The list of names of Config rules that you want to run evaluations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(String... configRuleNames);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> configRuleNames = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigRulesEvaluationRequest model) {
            setConfigRuleNames(model.configRuleNames);
        }

        public final Collection<String> getConfigRuleNames() {
            return configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ReevaluateConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String... configRuleNames) {
            if (this.configRuleNames == null) {
                this.configRuleNames = new SdkInternalList<>(configRuleNames.length);
            }
            for (String e : configRuleNames) {
                this.configRuleNames.add(e);
            }
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ReevaluateConfigRuleNamesCopier.copy(configRuleNames);
        }

        @SafeVarargs
        public final void setConfigRuleNames(String... configRuleNames) {
            if (this.configRuleNames == null) {
                this.configRuleNames = new SdkInternalList<>(configRuleNames.length);
            }
            for (String e : configRuleNames) {
                this.configRuleNames.add(e);
            }
        }

        @Override
        public StartConfigRulesEvaluationRequest build() {
            return new StartConfigRulesEvaluationRequest(this);
        }
    }
}
