/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.config.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ConfigurationRecorderStatus JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ConfigurationRecorderStatusUnmarshaller implements
        Unmarshaller<ConfigurationRecorderStatus, JsonUnmarshallerContext> {

    public ConfigurationRecorderStatus unmarshall(JsonUnmarshallerContext context) throws Exception {
        ConfigurationRecorderStatus.Builder configurationRecorderStatusBuilder = ConfigurationRecorderStatus.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    configurationRecorderStatusBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastStartTime", targetDepth)) {
                    context.nextToken();
                    configurationRecorderStatusBuilder.lastStartTime(context.getUnmarshaller(java.util.Date.class).unmarshall(
                            context));
                }
                if (context.testExpression("lastStopTime", targetDepth)) {
                    context.nextToken();
                    configurationRecorderStatusBuilder.lastStopTime(context.getUnmarshaller(java.util.Date.class).unmarshall(
                            context));
                }
                if (context.testExpression("recording", targetDepth)) {
                    context.nextToken();
                    configurationRecorderStatusBuilder.recording(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("lastStatus", targetDepth)) {
                    context.nextToken();
                    configurationRecorderStatusBuilder.lastStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastErrorCode", targetDepth)) {
                    context.nextToken();
                    configurationRecorderStatusBuilder.lastErrorCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastErrorMessage", targetDepth)) {
                    context.nextToken();
                    configurationRecorderStatusBuilder
                            .lastErrorMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastStatusChangeTime", targetDepth)) {
                    context.nextToken();
                    configurationRecorderStatusBuilder.lastStatusChangeTime(context.getUnmarshaller(java.util.Date.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return configurationRecorderStatusBuilder.build();
    }

    private static ConfigurationRecorderStatusUnmarshaller INSTANCE;

    public static ConfigurationRecorderStatusUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ConfigurationRecorderStatusUnmarshaller();
        return INSTANCE;
    }
}