/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.config.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DeliveryChannel JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeliveryChannelUnmarshaller implements Unmarshaller<DeliveryChannel, JsonUnmarshallerContext> {

    public DeliveryChannel unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeliveryChannel.Builder deliveryChannelBuilder = DeliveryChannel.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    deliveryChannelBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("s3BucketName", targetDepth)) {
                    context.nextToken();
                    deliveryChannelBuilder.s3BucketName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("s3KeyPrefix", targetDepth)) {
                    context.nextToken();
                    deliveryChannelBuilder.s3KeyPrefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("snsTopicARN", targetDepth)) {
                    context.nextToken();
                    deliveryChannelBuilder.snsTopicARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("configSnapshotDeliveryProperties", targetDepth)) {
                    context.nextToken();
                    deliveryChannelBuilder.configSnapshotDeliveryProperties(ConfigSnapshotDeliveryPropertiesUnmarshaller
                            .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return deliveryChannelBuilder.build();
    }

    private static DeliveryChannelUnmarshaller INSTANCE;

    public static DeliveryChannelUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DeliveryChannelUnmarshaller();
        return INSTANCE;
    }
}