/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.config.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * PutDeliveryChannelResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutDeliveryChannelResponseUnmarshaller implements Unmarshaller<PutDeliveryChannelResponse, JsonUnmarshallerContext> {

    public PutDeliveryChannelResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        PutDeliveryChannelResponse.Builder putDeliveryChannelResponseBuilder = PutDeliveryChannelResponse.builder();

        return putDeliveryChannelResponseBuilder.build();
    }

    private static PutDeliveryChannelResponseUnmarshaller INSTANCE;

    public static PutDeliveryChannelResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new PutDeliveryChannelResponseUnmarshaller();
        return INSTANCE;
    }
}