/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigRuleState;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.services.config.model.Scope;
import software.amazon.awssdk.services.config.model.Source;
import software.amazon.awssdk.services.config.transform.ConfigRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigRule
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigRule> {
    private final String configRuleName;
    private final String configRuleArn;
    private final String configRuleId;
    private final String description;
    private final Scope scope;
    private final Source source;
    private final String inputParameters;
    private final String maximumExecutionFrequency;
    private final String configRuleState;

    private ConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.configRuleArn = builder.configRuleArn;
        this.configRuleId = builder.configRuleId;
        this.description = builder.description;
        this.scope = builder.scope;
        this.source = builder.source;
        this.inputParameters = builder.inputParameters;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
        this.configRuleState = builder.configRuleState;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public String configRuleArn() {
        return this.configRuleArn;
    }

    public String configRuleId() {
        return this.configRuleId;
    }

    public String description() {
        return this.description;
    }

    public Scope scope() {
        return this.scope;
    }

    public Source source() {
        return this.source;
    }

    public String inputParameters() {
        return this.inputParameters;
    }

    public String maximumExecutionFrequency() {
        return this.maximumExecutionFrequency;
    }

    public String configRuleState() {
        return this.configRuleState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configRuleName() == null ? 0 : this.configRuleName().hashCode());
        hashCode = 31 * hashCode + (this.configRuleArn() == null ? 0 : this.configRuleArn().hashCode());
        hashCode = 31 * hashCode + (this.configRuleId() == null ? 0 : this.configRuleId().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.scope() == null ? 0 : this.scope().hashCode());
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        hashCode = 31 * hashCode + (this.inputParameters() == null ? 0 : this.inputParameters().hashCode());
        hashCode = 31 * hashCode + (this.maximumExecutionFrequency() == null ? 0 : this.maximumExecutionFrequency().hashCode());
        hashCode = 31 * hashCode + (this.configRuleState() == null ? 0 : this.configRuleState().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRule)) {
            return false;
        }
        ConfigRule other = (ConfigRule)obj;
        if (other.configRuleName() == null ^ this.configRuleName() == null) {
            return false;
        }
        if (other.configRuleName() != null && !other.configRuleName().equals(this.configRuleName())) {
            return false;
        }
        if (other.configRuleArn() == null ^ this.configRuleArn() == null) {
            return false;
        }
        if (other.configRuleArn() != null && !other.configRuleArn().equals(this.configRuleArn())) {
            return false;
        }
        if (other.configRuleId() == null ^ this.configRuleId() == null) {
            return false;
        }
        if (other.configRuleId() != null && !other.configRuleId().equals(this.configRuleId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.scope() == null ^ this.scope() == null) {
            return false;
        }
        if (other.scope() != null && !other.scope().equals(this.scope())) {
            return false;
        }
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.inputParameters() == null ^ this.inputParameters() == null) {
            return false;
        }
        if (other.inputParameters() != null && !other.inputParameters().equals(this.inputParameters())) {
            return false;
        }
        if (other.maximumExecutionFrequency() == null ^ this.maximumExecutionFrequency() == null) {
            return false;
        }
        if (other.maximumExecutionFrequency() != null && !other.maximumExecutionFrequency().equals(this.maximumExecutionFrequency())) {
            return false;
        }
        if (other.configRuleState() == null ^ this.configRuleState() == null) {
            return false;
        }
        return other.configRuleState() == null || other.configRuleState().equals(this.configRuleState());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configRuleName() != null) {
            sb.append("ConfigRuleName: ").append(this.configRuleName()).append(",");
        }
        if (this.configRuleArn() != null) {
            sb.append("ConfigRuleArn: ").append(this.configRuleArn()).append(",");
        }
        if (this.configRuleId() != null) {
            sb.append("ConfigRuleId: ").append(this.configRuleId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.scope() != null) {
            sb.append("Scope: ").append(this.scope()).append(",");
        }
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.inputParameters() != null) {
            sb.append("InputParameters: ").append(this.inputParameters()).append(",");
        }
        if (this.maximumExecutionFrequency() != null) {
            sb.append("MaximumExecutionFrequency: ").append(this.maximumExecutionFrequency()).append(",");
        }
        if (this.configRuleState() != null) {
            sb.append("ConfigRuleState: ").append(this.configRuleState()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String configRuleArn;
        private String configRuleId;
        private String description;
        private Scope scope;
        private Source source;
        private String inputParameters;
        private String maximumExecutionFrequency;
        private String configRuleState;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRule model) {
            this.setConfigRuleName(model.configRuleName);
            this.setConfigRuleArn(model.configRuleArn);
            this.setConfigRuleId(model.configRuleId);
            this.setDescription(model.description);
            this.setScope(model.scope);
            this.setSource(model.source);
            this.setInputParameters(model.inputParameters);
            this.setMaximumExecutionFrequency(model.maximumExecutionFrequency);
            this.setConfigRuleState(model.configRuleState);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getConfigRuleArn() {
            return this.configRuleArn;
        }

        @Override
        public final Builder configRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
            return this;
        }

        public final void setConfigRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
        }

        public final String getConfigRuleId() {
            return this.configRuleId;
        }

        @Override
        public final Builder configRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
            return this;
        }

        public final void setConfigRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Scope getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(Scope scope) {
            this.scope = scope;
        }

        public final Source getSource() {
            return this.source;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source source) {
            this.source = source;
        }

        public final String getInputParameters() {
            return this.inputParameters;
        }

        @Override
        public final Builder inputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public final void setInputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
        }

        public final String getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency.toString());
            return this;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        public final void setMaximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency.toString());
        }

        public final String getConfigRuleState() {
            return this.configRuleState;
        }

        @Override
        public final Builder configRuleState(String configRuleState) {
            this.configRuleState = configRuleState;
            return this;
        }

        @Override
        public final Builder configRuleState(ConfigRuleState configRuleState) {
            this.configRuleState(configRuleState.toString());
            return this;
        }

        public final void setConfigRuleState(String configRuleState) {
            this.configRuleState = configRuleState;
        }

        public final void setConfigRuleState(ConfigRuleState configRuleState) {
            this.configRuleState(configRuleState.toString());
        }

        public ConfigRule build() {
            return new ConfigRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigRule> {
        public Builder configRuleName(String var1);

        public Builder configRuleArn(String var1);

        public Builder configRuleId(String var1);

        public Builder description(String var1);

        public Builder scope(Scope var1);

        public Builder source(Source var1);

        public Builder inputParameters(String var1);

        public Builder maximumExecutionFrequency(String var1);

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency var1);

        public Builder configRuleState(String var1);

        public Builder configRuleState(ConfigRuleState var1);
    }
}

