/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.RecordingGroup;
import software.amazon.awssdk.services.config.transform.ConfigurationRecorderMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationRecorder
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigurationRecorder> {
    private final String name;
    private final String roleARN;
    private final RecordingGroup recordingGroup;

    private ConfigurationRecorder(BuilderImpl builder) {
        this.name = builder.name;
        this.roleARN = builder.roleARN;
        this.recordingGroup = builder.recordingGroup;
    }

    public String name() {
        return this.name;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public RecordingGroup recordingGroup() {
        return this.recordingGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.recordingGroup() == null ? 0 : this.recordingGroup().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorder)) {
            return false;
        }
        ConfigurationRecorder other = (ConfigurationRecorder)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.recordingGroup() == null ^ this.recordingGroup() == null) {
            return false;
        }
        return other.recordingGroup() == null || other.recordingGroup().equals(this.recordingGroup());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.recordingGroup() != null) {
            sb.append("RecordingGroup: ").append(this.recordingGroup()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationRecorderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String roleARN;
        private RecordingGroup recordingGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorder model) {
            this.setName(model.name);
            this.setRoleARN(model.roleARN);
            this.setRecordingGroup(model.recordingGroup);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final RecordingGroup getRecordingGroup() {
            return this.recordingGroup;
        }

        @Override
        public final Builder recordingGroup(RecordingGroup recordingGroup) {
            this.recordingGroup = recordingGroup;
            return this;
        }

        public final void setRecordingGroup(RecordingGroup recordingGroup) {
            this.recordingGroup = recordingGroup;
        }

        public ConfigurationRecorder build() {
            return new ConfigurationRecorder(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationRecorder> {
        public Builder name(String var1);

        public Builder roleARN(String var1);

        public Builder recordingGroup(RecordingGroup var1);
    }
}

