/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.config.model.ResourceIdentifier;
import software.amazon.awssdk.services.config.model.ResourceIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDiscoveredResourcesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDiscoveredResourcesResponse> {
    private final List<ResourceIdentifier> resourceIdentifiers;
    private final String nextToken;

    private ListDiscoveredResourcesResponse(BuilderImpl builder) {
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public List<ResourceIdentifier> resourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceIdentifiers() == null ? 0 : this.resourceIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesResponse)) {
            return false;
        }
        ListDiscoveredResourcesResponse other = (ListDiscoveredResourcesResponse)((Object)obj);
        if (other.resourceIdentifiers() == null ^ this.resourceIdentifiers() == null) {
            return false;
        }
        if (other.resourceIdentifiers() != null && !other.resourceIdentifiers().equals(this.resourceIdentifiers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceIdentifiers() != null) {
            sb.append("ResourceIdentifiers: ").append(this.resourceIdentifiers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ResourceIdentifier> resourceIdentifiers = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesResponse model) {
            this.setResourceIdentifiers(model.resourceIdentifiers);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ResourceIdentifier> getResourceIdentifiers() {
            return this.resourceIdentifiers;
        }

        @Override
        public final Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(ResourceIdentifier ... resourceIdentifiers) {
            if (this.resourceIdentifiers == null) {
                this.resourceIdentifiers = new SdkInternalList(resourceIdentifiers.length);
            }
            for (ResourceIdentifier e : resourceIdentifiers) {
                this.resourceIdentifiers.add(e);
            }
            return this;
        }

        public final void setResourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copy(resourceIdentifiers);
        }

        @SafeVarargs
        public final void setResourceIdentifiers(ResourceIdentifier ... resourceIdentifiers) {
            if (this.resourceIdentifiers == null) {
                this.resourceIdentifiers = new SdkInternalList(resourceIdentifiers.length);
            }
            for (ResourceIdentifier e : resourceIdentifiers) {
                this.resourceIdentifiers.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDiscoveredResourcesResponse build() {
            return new ListDiscoveredResourcesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDiscoveredResourcesResponse> {
        public Builder resourceIdentifiers(Collection<ResourceIdentifier> var1);

        public Builder resourceIdentifiers(ResourceIdentifier ... var1);

        public Builder nextToken(String var1);
    }
}

