/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.model.ResourceTypeListCopier;
import software.amazon.awssdk.services.config.transform.RecordingGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecordingGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, RecordingGroup> {
    private final Boolean allSupported;
    private final Boolean includeGlobalResourceTypes;
    private final List<String> resourceTypes;

    private RecordingGroup(BuilderImpl builder) {
        this.allSupported = builder.allSupported;
        this.includeGlobalResourceTypes = builder.includeGlobalResourceTypes;
        this.resourceTypes = builder.resourceTypes;
    }

    public Boolean allSupported() {
        return this.allSupported;
    }

    public Boolean includeGlobalResourceTypes() {
        return this.includeGlobalResourceTypes;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.allSupported() == null ? 0 : this.allSupported().hashCode());
        hashCode = 31 * hashCode + (this.includeGlobalResourceTypes() == null ? 0 : this.includeGlobalResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.resourceTypes() == null ? 0 : this.resourceTypes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingGroup)) {
            return false;
        }
        RecordingGroup other = (RecordingGroup)obj;
        if (other.allSupported() == null ^ this.allSupported() == null) {
            return false;
        }
        if (other.allSupported() != null && !other.allSupported().equals(this.allSupported())) {
            return false;
        }
        if (other.includeGlobalResourceTypes() == null ^ this.includeGlobalResourceTypes() == null) {
            return false;
        }
        if (other.includeGlobalResourceTypes() != null && !other.includeGlobalResourceTypes().equals(this.includeGlobalResourceTypes())) {
            return false;
        }
        if (other.resourceTypes() == null ^ this.resourceTypes() == null) {
            return false;
        }
        return other.resourceTypes() == null || other.resourceTypes().equals(this.resourceTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allSupported() != null) {
            sb.append("AllSupported: ").append(this.allSupported()).append(",");
        }
        if (this.includeGlobalResourceTypes() != null) {
            sb.append("IncludeGlobalResourceTypes: ").append(this.includeGlobalResourceTypes()).append(",");
        }
        if (this.resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.resourceTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordingGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean allSupported;
        private Boolean includeGlobalResourceTypes;
        private List<String> resourceTypes = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingGroup model) {
            this.setAllSupported(model.allSupported);
            this.setIncludeGlobalResourceTypes(model.includeGlobalResourceTypes);
            this.setResourceTypes(model.resourceTypes);
        }

        public final Boolean getAllSupported() {
            return this.allSupported;
        }

        @Override
        public final Builder allSupported(Boolean allSupported) {
            this.allSupported = allSupported;
            return this;
        }

        public final void setAllSupported(Boolean allSupported) {
            this.allSupported = allSupported;
        }

        public final Boolean getIncludeGlobalResourceTypes() {
            return this.includeGlobalResourceTypes;
        }

        @Override
        public final Builder includeGlobalResourceTypes(Boolean includeGlobalResourceTypes) {
            this.includeGlobalResourceTypes = includeGlobalResourceTypes;
            return this;
        }

        public final void setIncludeGlobalResourceTypes(Boolean includeGlobalResourceTypes) {
            this.includeGlobalResourceTypes = includeGlobalResourceTypes;
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            if (this.resourceTypes == null) {
                this.resourceTypes = new SdkInternalList(resourceTypes.length);
            }
            for (String e : resourceTypes) {
                this.resourceTypes.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType ... resourceTypes) {
            if (this.resourceTypes == null) {
                this.resourceTypes = new SdkInternalList(resourceTypes.length);
            }
            for (ResourceType ele : resourceTypes) {
                this.resourceTypes.add(ele.toString());
            }
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
        }

        @SafeVarargs
        public final void setResourceTypes(String ... resourceTypes) {
            if (this.resourceTypes == null) {
                this.resourceTypes = new SdkInternalList(resourceTypes.length);
            }
            for (String e : resourceTypes) {
                this.resourceTypes.add(e);
            }
        }

        @SafeVarargs
        public final void setResourceTypes(ResourceType ... resourceTypes) {
            if (this.resourceTypes == null) {
                this.resourceTypes = new SdkInternalList(resourceTypes.length);
            }
            for (ResourceType ele : resourceTypes) {
                this.resourceTypes.add(ele.toString());
            }
        }

        public RecordingGroup build() {
            return new RecordingGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecordingGroup> {
        public Builder allSupported(Boolean var1);

        public Builder includeGlobalResourceTypes(Boolean var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder resourceTypes(ResourceType ... var1);
    }
}

