/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ComplianceContributorCountMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of AWS resources or AWS Config rules responsible for the current compliance of the item, up to a maximum
 * number.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComplianceContributorCount implements StructuredPojo,
        ToCopyableBuilder<ComplianceContributorCount.Builder, ComplianceContributorCount> {
    private final Integer cappedCount;

    private final Boolean capExceeded;

    private ComplianceContributorCount(BuilderImpl builder) {
        this.cappedCount = builder.cappedCount;
        this.capExceeded = builder.capExceeded;
    }

    /**
     * <p>
     * The number of AWS resources or AWS Config rules responsible for the current compliance of the item.
     * </p>
     * 
     * @return The number of AWS resources or AWS Config rules responsible for the current compliance of the item.
     */
    public Integer cappedCount() {
        return cappedCount;
    }

    /**
     * <p>
     * Indicates whether the maximum count is reached.
     * </p>
     * 
     * @return Indicates whether the maximum count is reached.
     */
    public Boolean capExceeded() {
        return capExceeded;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cappedCount());
        hashCode = 31 * hashCode + Objects.hashCode(capExceeded());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceContributorCount)) {
            return false;
        }
        ComplianceContributorCount other = (ComplianceContributorCount) obj;
        return Objects.equals(cappedCount(), other.cappedCount()) && Objects.equals(capExceeded(), other.capExceeded());
    }

    @Override
    public String toString() {
        return ToString.builder("ComplianceContributorCount").add("CappedCount", cappedCount()).add("CapExceeded", capExceeded())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CappedCount":
            return Optional.of(clazz.cast(cappedCount()));
        case "CapExceeded":
            return Optional.of(clazz.cast(capExceeded()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceContributorCountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComplianceContributorCount> {
        /**
         * <p>
         * The number of AWS resources or AWS Config rules responsible for the current compliance of the item.
         * </p>
         * 
         * @param cappedCount
         *        The number of AWS resources or AWS Config rules responsible for the current compliance of the item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cappedCount(Integer cappedCount);

        /**
         * <p>
         * Indicates whether the maximum count is reached.
         * </p>
         * 
         * @param capExceeded
         *        Indicates whether the maximum count is reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capExceeded(Boolean capExceeded);
    }

    static final class BuilderImpl implements Builder {
        private Integer cappedCount;

        private Boolean capExceeded;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceContributorCount model) {
            cappedCount(model.cappedCount);
            capExceeded(model.capExceeded);
        }

        public final Integer getCappedCount() {
            return cappedCount;
        }

        @Override
        public final Builder cappedCount(Integer cappedCount) {
            this.cappedCount = cappedCount;
            return this;
        }

        public final void setCappedCount(Integer cappedCount) {
            this.cappedCount = cappedCount;
        }

        public final Boolean getCapExceeded() {
            return capExceeded;
        }

        @Override
        public final Builder capExceeded(Boolean capExceeded) {
            this.capExceeded = capExceeded;
            return this;
        }

        public final void setCapExceeded(Boolean capExceeded) {
            this.capExceeded = capExceeded;
        }

        @Override
        public ComplianceContributorCount build() {
            return new ComplianceContributorCount(this);
        }
    }
}
