/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ConfigRuleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An AWS Config rule represents an AWS Lambda function that you create for a custom rule or a predefined function for
 * an AWS managed rule. The function evaluates configuration items to assess whether your AWS resources comply with your
 * desired configurations. This function can run when AWS Config detects a configuration change to an AWS resource and
 * at a periodic frequency that you choose (for example, every 24 hours).
 * </p>
 * <note>
 * <p>
 * You can use the AWS CLI and AWS SDKs if you want to create a rule that triggers evaluations for your resources when
 * AWS Config delivers the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.
 * </p>
 * </note>
 * <p>
 * For more information about developing and using AWS Config rules, see <a
 * href="http://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating AWS Resource
 * Configurations with AWS Config</a> in the <i>AWS Config Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigRule implements StructuredPojo, ToCopyableBuilder<ConfigRule.Builder, ConfigRule> {
    private final String configRuleName;

    private final String configRuleArn;

    private final String configRuleId;

    private final String description;

    private final Scope scope;

    private final Source source;

    private final String inputParameters;

    private final String maximumExecutionFrequency;

    private final String configRuleState;

    private ConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.configRuleArn = builder.configRuleArn;
        this.configRuleId = builder.configRuleId;
        this.description = builder.description;
        this.scope = builder.scope;
        this.source = builder.source;
        this.inputParameters = builder.inputParameters;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
        this.configRuleState = builder.configRuleState;
    }

    /**
     * <p>
     * The name that you assign to the AWS Config rule. The name is required if you are adding a new rule.
     * </p>
     * 
     * @return The name that you assign to the AWS Config rule. The name is required if you are adding a new rule.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Config rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Config rule.
     */
    public String configRuleArn() {
        return configRuleArn;
    }

    /**
     * <p>
     * The ID of the AWS Config rule.
     * </p>
     * 
     * @return The ID of the AWS Config rule.
     */
    public String configRuleId() {
        return configRuleId;
    }

    /**
     * <p>
     * The description that you provide for the AWS Config rule.
     * </p>
     * 
     * @return The description that you provide for the AWS Config rule.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types,
     * a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope
     * to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope,
     * evaluations are triggered when any resource in the recording group changes.
     * </p>
     * 
     * @return Defines which resources can trigger an evaluation for the rule. The scope can include one or more
     *         resource types, a combination of one resource type and one resource ID, or a combination of a tag key and
     *         value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do
     *         not specify a scope, evaluations are triggered when any resource in the recording group changes.
     */
    public Scope scope() {
        return scope;
    }

    /**
     * <p>
     * Provides the rule owner (AWS or customer), the rule identifier, and the notifications that cause the function to
     * evaluate your AWS resources.
     * </p>
     * 
     * @return Provides the rule owner (AWS or customer), the rule identifier, and the notifications that cause the
     *         function to evaluate your AWS resources.
     */
    public Source source() {
        return source;
    }

    /**
     * <p>
     * A string in JSON format that is passed to the AWS Config rule Lambda function.
     * </p>
     * 
     * @return A string in JSON format that is passed to the AWS Config rule Lambda function.
     */
    public String inputParameters() {
        return inputParameters;
    }

    /**
     * <p>
     * The maximum frequency with which AWS Config runs evaluations for a rule. You can specify a value for
     * <code>MaximumExecutionFrequency</code> when:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are using an AWS managed rule that is triggered at a periodic frequency.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see
     * <a>ConfigSnapshotDeliveryProperties</a>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
     * value for the <code>MaximumExecutionFrequency</code> parameter.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumExecutionFrequency} will return {@link MaximumExecutionFrequency#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumExecutionFrequencyAsString}.
     * </p>
     * 
     * @return The maximum frequency with which AWS Config runs evaluations for a rule. You can specify a value for
     *         <code>MaximumExecutionFrequency</code> when:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You are using an AWS managed rule that is triggered at a periodic frequency.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information,
     *         see <a>ConfigSnapshotDeliveryProperties</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify
     *         a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     *         </p>
     * @see MaximumExecutionFrequency
     */
    public MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(maximumExecutionFrequency);
    }

    /**
     * <p>
     * The maximum frequency with which AWS Config runs evaluations for a rule. You can specify a value for
     * <code>MaximumExecutionFrequency</code> when:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are using an AWS managed rule that is triggered at a periodic frequency.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see
     * <a>ConfigSnapshotDeliveryProperties</a>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
     * value for the <code>MaximumExecutionFrequency</code> parameter.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumExecutionFrequency} will return {@link MaximumExecutionFrequency#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumExecutionFrequencyAsString}.
     * </p>
     * 
     * @return The maximum frequency with which AWS Config runs evaluations for a rule. You can specify a value for
     *         <code>MaximumExecutionFrequency</code> when:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You are using an AWS managed rule that is triggered at a periodic frequency.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information,
     *         see <a>ConfigSnapshotDeliveryProperties</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify
     *         a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     *         </p>
     * @see MaximumExecutionFrequency
     */
    public String maximumExecutionFrequencyAsString() {
        return maximumExecutionFrequency;
    }

    /**
     * <p>
     * Indicates whether the AWS Config rule is active or is currently being deleted by AWS Config. It can also indicate
     * the evaluation status for the Config rule.
     * </p>
     * <p>
     * AWS Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the
     * <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.
     * </p>
     * <p>
     * AWS Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the
     * <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config rule.
     * </p>
     * <p>
     * AWS Config sets the state of a rule to <code>DELETING</code> temporarily after you use the
     * <code>DeleteConfigRule</code> request to delete the rule. After AWS Config deletes the rule, the rule and all of
     * its evaluations are erased and are no longer available.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configRuleState}
     * will return {@link ConfigRuleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configRuleStateAsString}.
     * </p>
     * 
     * @return Indicates whether the AWS Config rule is active or is currently being deleted by AWS Config. It can also
     *         indicate the evaluation status for the Config rule.</p>
     *         <p>
     *         AWS Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the
     *         <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.
     *         </p>
     *         <p>
     *         AWS Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the
     *         <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config
     *         rule.
     *         </p>
     *         <p>
     *         AWS Config sets the state of a rule to <code>DELETING</code> temporarily after you use the
     *         <code>DeleteConfigRule</code> request to delete the rule. After AWS Config deletes the rule, the rule and
     *         all of its evaluations are erased and are no longer available.
     * @see ConfigRuleState
     */
    public ConfigRuleState configRuleState() {
        return ConfigRuleState.fromValue(configRuleState);
    }

    /**
     * <p>
     * Indicates whether the AWS Config rule is active or is currently being deleted by AWS Config. It can also indicate
     * the evaluation status for the Config rule.
     * </p>
     * <p>
     * AWS Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the
     * <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.
     * </p>
     * <p>
     * AWS Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the
     * <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config rule.
     * </p>
     * <p>
     * AWS Config sets the state of a rule to <code>DELETING</code> temporarily after you use the
     * <code>DeleteConfigRule</code> request to delete the rule. After AWS Config deletes the rule, the rule and all of
     * its evaluations are erased and are no longer available.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configRuleState}
     * will return {@link ConfigRuleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configRuleStateAsString}.
     * </p>
     * 
     * @return Indicates whether the AWS Config rule is active or is currently being deleted by AWS Config. It can also
     *         indicate the evaluation status for the Config rule.</p>
     *         <p>
     *         AWS Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the
     *         <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.
     *         </p>
     *         <p>
     *         AWS Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the
     *         <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config
     *         rule.
     *         </p>
     *         <p>
     *         AWS Config sets the state of a rule to <code>DELETING</code> temporarily after you use the
     *         <code>DeleteConfigRule</code> request to delete the rule. After AWS Config deletes the rule, the rule and
     *         all of its evaluations are erased and are no longer available.
     * @see ConfigRuleState
     */
    public String configRuleStateAsString() {
        return configRuleState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(configRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(configRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(inputParameters());
        hashCode = 31 * hashCode + Objects.hashCode(maximumExecutionFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configRuleStateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRule)) {
            return false;
        }
        ConfigRule other = (ConfigRule) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(configRuleArn(), other.configRuleArn())
                && Objects.equals(configRuleId(), other.configRuleId()) && Objects.equals(description(), other.description())
                && Objects.equals(scope(), other.scope()) && Objects.equals(source(), other.source())
                && Objects.equals(inputParameters(), other.inputParameters())
                && Objects.equals(maximumExecutionFrequencyAsString(), other.maximumExecutionFrequencyAsString())
                && Objects.equals(configRuleStateAsString(), other.configRuleStateAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("ConfigRule").add("ConfigRuleName", configRuleName()).add("ConfigRuleArn", configRuleArn())
                .add("ConfigRuleId", configRuleId()).add("Description", description()).add("Scope", scope())
                .add("Source", source()).add("InputParameters", inputParameters())
                .add("MaximumExecutionFrequency", maximumExecutionFrequencyAsString())
                .add("ConfigRuleState", configRuleStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.of(clazz.cast(configRuleName()));
        case "ConfigRuleArn":
            return Optional.of(clazz.cast(configRuleArn()));
        case "ConfigRuleId":
            return Optional.of(clazz.cast(configRuleId()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Scope":
            return Optional.of(clazz.cast(scope()));
        case "Source":
            return Optional.of(clazz.cast(source()));
        case "InputParameters":
            return Optional.of(clazz.cast(inputParameters()));
        case "MaximumExecutionFrequency":
            return Optional.of(clazz.cast(maximumExecutionFrequencyAsString()));
        case "ConfigRuleState":
            return Optional.of(clazz.cast(configRuleStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ConfigRule> {
        /**
         * <p>
         * The name that you assign to the AWS Config rule. The name is required if you are adding a new rule.
         * </p>
         * 
         * @param configRuleName
         *        The name that you assign to the AWS Config rule. The name is required if you are adding a new rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Config rule.
         * </p>
         * 
         * @param configRuleArn
         *        The Amazon Resource Name (ARN) of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleArn(String configRuleArn);

        /**
         * <p>
         * The ID of the AWS Config rule.
         * </p>
         * 
         * @param configRuleId
         *        The ID of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleId(String configRuleId);

        /**
         * <p>
         * The description that you provide for the AWS Config rule.
         * </p>
         * 
         * @param description
         *        The description that you provide for the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource
         * types, a combination of one resource type and one resource ID, or a combination of a tag key and value.
         * Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify
         * a scope, evaluations are triggered when any resource in the recording group changes.
         * </p>
         * 
         * @param scope
         *        Defines which resources can trigger an evaluation for the rule. The scope can include one or more
         *        resource types, a combination of one resource type and one resource ID, or a combination of a tag key
         *        and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If
         *        you do not specify a scope, evaluations are triggered when any resource in the recording group
         *        changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource
         * types, a combination of one resource type and one resource ID, or a combination of a tag key and value.
         * Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify
         * a scope, evaluations are triggered when any resource in the recording group changes.
         * </p>
         * This is a convenience that creates an instance of the {@link Scope.Builder} avoiding the need to create one
         * manually via {@link Scope#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scope.Builder#build()} is called immediately and its result is
         * passed to {@link #scope(Scope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link Scope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(Scope)
         */
        default Builder scope(Consumer<Scope.Builder> scope) {
            return scope(Scope.builder().apply(scope).build());
        }

        /**
         * <p>
         * Provides the rule owner (AWS or customer), the rule identifier, and the notifications that cause the function
         * to evaluate your AWS resources.
         * </p>
         * 
         * @param source
         *        Provides the rule owner (AWS or customer), the rule identifier, and the notifications that cause the
         *        function to evaluate your AWS resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * Provides the rule owner (AWS or customer), the rule identifier, and the notifications that cause the function
         * to evaluate your AWS resources.
         * </p>
         * This is a convenience that creates an instance of the {@link Source.Builder} avoiding the need to create one
         * manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().apply(source).build());
        }

        /**
         * <p>
         * A string in JSON format that is passed to the AWS Config rule Lambda function.
         * </p>
         * 
         * @param inputParameters
         *        A string in JSON format that is passed to the AWS Config rule Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParameters(String inputParameters);

        /**
         * <p>
         * The maximum frequency with which AWS Config runs evaluations for a rule. You can specify a value for
         * <code>MaximumExecutionFrequency</code> when:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You are using an AWS managed rule that is triggered at a periodic frequency.
         * </p>
         * </li>
         * <li>
         * <p>
         * Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see
         * <a>ConfigSnapshotDeliveryProperties</a>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a
         * valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * </p>
         * </note>
         * 
         * @param maximumExecutionFrequency
         *        The maximum frequency with which AWS Config runs evaluations for a rule. You can specify a value for
         *        <code>MaximumExecutionFrequency</code> when:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        You are using an AWS managed rule that is triggered at a periodic frequency.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more
         *        information, see <a>ConfigSnapshotDeliveryProperties</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency,
         *        specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         *        </p>
         * @see MaximumExecutionFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumExecutionFrequency
         */
        Builder maximumExecutionFrequency(String maximumExecutionFrequency);

        /**
         * <p>
         * The maximum frequency with which AWS Config runs evaluations for a rule. You can specify a value for
         * <code>MaximumExecutionFrequency</code> when:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You are using an AWS managed rule that is triggered at a periodic frequency.
         * </p>
         * </li>
         * <li>
         * <p>
         * Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see
         * <a>ConfigSnapshotDeliveryProperties</a>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a
         * valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * </p>
         * </note>
         * 
         * @param maximumExecutionFrequency
         *        The maximum frequency with which AWS Config runs evaluations for a rule. You can specify a value for
         *        <code>MaximumExecutionFrequency</code> when:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        You are using an AWS managed rule that is triggered at a periodic frequency.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more
         *        information, see <a>ConfigSnapshotDeliveryProperties</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency,
         *        specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         *        </p>
         * @see MaximumExecutionFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumExecutionFrequency
         */
        Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency);

        /**
         * <p>
         * Indicates whether the AWS Config rule is active or is currently being deleted by AWS Config. It can also
         * indicate the evaluation status for the Config rule.
         * </p>
         * <p>
         * AWS Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the
         * <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.
         * </p>
         * <p>
         * AWS Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the
         * <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config rule.
         * </p>
         * <p>
         * AWS Config sets the state of a rule to <code>DELETING</code> temporarily after you use the
         * <code>DeleteConfigRule</code> request to delete the rule. After AWS Config deletes the rule, the rule and all
         * of its evaluations are erased and are no longer available.
         * </p>
         * 
         * @param configRuleState
         *        Indicates whether the AWS Config rule is active or is currently being deleted by AWS Config. It can
         *        also indicate the evaluation status for the Config rule.</p>
         *        <p>
         *        AWS Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the
         *        <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.
         *        </p>
         *        <p>
         *        AWS Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the
         *        <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config
         *        rule.
         *        </p>
         *        <p>
         *        AWS Config sets the state of a rule to <code>DELETING</code> temporarily after you use the
         *        <code>DeleteConfigRule</code> request to delete the rule. After AWS Config deletes the rule, the rule
         *        and all of its evaluations are erased and are no longer available.
         * @see ConfigRuleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigRuleState
         */
        Builder configRuleState(String configRuleState);

        /**
         * <p>
         * Indicates whether the AWS Config rule is active or is currently being deleted by AWS Config. It can also
         * indicate the evaluation status for the Config rule.
         * </p>
         * <p>
         * AWS Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the
         * <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.
         * </p>
         * <p>
         * AWS Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the
         * <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config rule.
         * </p>
         * <p>
         * AWS Config sets the state of a rule to <code>DELETING</code> temporarily after you use the
         * <code>DeleteConfigRule</code> request to delete the rule. After AWS Config deletes the rule, the rule and all
         * of its evaluations are erased and are no longer available.
         * </p>
         * 
         * @param configRuleState
         *        Indicates whether the AWS Config rule is active or is currently being deleted by AWS Config. It can
         *        also indicate the evaluation status for the Config rule.</p>
         *        <p>
         *        AWS Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the
         *        <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.
         *        </p>
         *        <p>
         *        AWS Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the
         *        <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config
         *        rule.
         *        </p>
         *        <p>
         *        AWS Config sets the state of a rule to <code>DELETING</code> temporarily after you use the
         *        <code>DeleteConfigRule</code> request to delete the rule. After AWS Config deletes the rule, the rule
         *        and all of its evaluations are erased and are no longer available.
         * @see ConfigRuleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigRuleState
         */
        Builder configRuleState(ConfigRuleState configRuleState);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String configRuleArn;

        private String configRuleId;

        private String description;

        private Scope scope;

        private Source source;

        private String inputParameters;

        private String maximumExecutionFrequency;

        private String configRuleState;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRule model) {
            configRuleName(model.configRuleName);
            configRuleArn(model.configRuleArn);
            configRuleId(model.configRuleId);
            description(model.description);
            scope(model.scope);
            source(model.source);
            inputParameters(model.inputParameters);
            maximumExecutionFrequency(model.maximumExecutionFrequency);
            configRuleState(model.configRuleState);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getConfigRuleArn() {
            return configRuleArn;
        }

        @Override
        public final Builder configRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
            return this;
        }

        public final void setConfigRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
        }

        public final String getConfigRuleId() {
            return configRuleId;
        }

        @Override
        public final Builder configRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
            return this;
        }

        public final void setConfigRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Scope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final String getInputParameters() {
            return inputParameters;
        }

        @Override
        public final Builder inputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public final void setInputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
        }

        public final String getMaximumExecutionFrequency() {
            return maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency.toString());
            return this;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        public final String getConfigRuleState() {
            return configRuleState;
        }

        @Override
        public final Builder configRuleState(String configRuleState) {
            this.configRuleState = configRuleState;
            return this;
        }

        @Override
        public final Builder configRuleState(ConfigRuleState configRuleState) {
            this.configRuleState(configRuleState.toString());
            return this;
        }

        public final void setConfigRuleState(String configRuleState) {
            this.configRuleState = configRuleState;
        }

        @Override
        public ConfigRule build() {
            return new ConfigRule(this);
        }
    }
}
