/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigRuleEvaluationStatusRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeConfigRuleEvaluationStatusRequest.Builder, DescribeConfigRuleEvaluationStatusRequest> {
    private final List<String> configRuleNames;

    private final String nextToken;

    private final Integer limit;

    private DescribeConfigRuleEvaluationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleNames = builder.configRuleNames;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the AWS managed Config rules for which you want status information. If you do not specify any names,
     * AWS Config returns status information for all AWS managed Config rules that you use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The name of the AWS managed Config rules for which you want status information. If you do not specify any
     *         names, AWS Config returns status information for all AWS managed Config rules that you use.
     */
    public List<String> configRuleNames() {
        return configRuleNames;
    }

    /**
     * <p>
     * The <code>NextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>NextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of rule evaluation results that you want returned.
     * </p>
     * <p>
     * This parameter is required if the rule limit for your account is more than the default of 50 rules.
     * </p>
     * <p>
     * For more information about requesting a rule limit increase, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">AWS Config Limits</a>
     * in the <i>AWS General Reference Guide</i>.
     * </p>
     * 
     * @return The number of rule evaluation results that you want returned.</p>
     *         <p>
     *         This parameter is required if the rule limit for your account is more than the default of 50 rules.
     *         </p>
     *         <p>
     *         For more information about requesting a rule limit increase, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">AWS Config
     *         Limits</a> in the <i>AWS General Reference Guide</i>.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleNames());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRuleEvaluationStatusRequest)) {
            return false;
        }
        DescribeConfigRuleEvaluationStatusRequest other = (DescribeConfigRuleEvaluationStatusRequest) obj;
        return Objects.equals(configRuleNames(), other.configRuleNames()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(limit(), other.limit());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeConfigRuleEvaluationStatusRequest").add("ConfigRuleNames", configRuleNames())
                .add("NextToken", nextToken()).add("Limit", limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleNames":
            return Optional.of(clazz.cast(configRuleNames()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "Limit":
            return Optional.of(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, DescribeConfigRuleEvaluationStatusRequest> {
        /**
         * <p>
         * The name of the AWS managed Config rules for which you want status information. If you do not specify any
         * names, AWS Config returns status information for all AWS managed Config rules that you use.
         * </p>
         * 
         * @param configRuleNames
         *        The name of the AWS managed Config rules for which you want status information. If you do not specify
         *        any names, AWS Config returns status information for all AWS managed Config rules that you use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(Collection<String> configRuleNames);

        /**
         * <p>
         * The name of the AWS managed Config rules for which you want status information. If you do not specify any
         * names, AWS Config returns status information for all AWS managed Config rules that you use.
         * </p>
         * 
         * @param configRuleNames
         *        The name of the AWS managed Config rules for which you want status information. If you do not specify
         *        any names, AWS Config returns status information for all AWS managed Config rules that you use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(String... configRuleNames);

        /**
         * <p>
         * The <code>NextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of rule evaluation results that you want returned.
         * </p>
         * <p>
         * This parameter is required if the rule limit for your account is more than the default of 50 rules.
         * </p>
         * <p>
         * For more information about requesting a rule limit increase, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">AWS Config
         * Limits</a> in the <i>AWS General Reference Guide</i>.
         * </p>
         * 
         * @param limit
         *        The number of rule evaluation results that you want returned.</p>
         *        <p>
         *        This parameter is required if the rule limit for your account is more than the default of 50 rules.
         *        </p>
         *        <p>
         *        For more information about requesting a rule limit increase, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">AWS Config
         *        Limits</a> in the <i>AWS General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> configRuleNames;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRuleEvaluationStatusRequest model) {
            super(model);
            configRuleNames(model.configRuleNames);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final Collection<String> getConfigRuleNames() {
            return configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String... configRuleNames) {
            configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigRuleEvaluationStatusRequest build() {
            return new DescribeConfigRuleEvaluationStatusRequest(this);
        }
    }
}
