/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeConfigurationRecorderStatus</a> action in JSON format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigurationRecorderStatusResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeConfigurationRecorderStatusResponse.Builder, DescribeConfigurationRecorderStatusResponse> {
    private final List<ConfigurationRecorderStatus> configurationRecordersStatus;

    private DescribeConfigurationRecorderStatusResponse(BuilderImpl builder) {
        super(builder);
        this.configurationRecordersStatus = builder.configurationRecordersStatus;
    }

    /**
     * <p>
     * A list that contains status of the specified recorders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains status of the specified recorders.
     */
    public List<ConfigurationRecorderStatus> configurationRecordersStatus() {
        return configurationRecordersStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationRecordersStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecorderStatusResponse)) {
            return false;
        }
        DescribeConfigurationRecorderStatusResponse other = (DescribeConfigurationRecorderStatusResponse) obj;
        return Objects.equals(configurationRecordersStatus(), other.configurationRecordersStatus());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationRecorderStatusResponse")
                .add("ConfigurationRecordersStatus", configurationRecordersStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecordersStatus":
            return Optional.of(clazz.cast(configurationRecordersStatus()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder,
            CopyableBuilder<Builder, DescribeConfigurationRecorderStatusResponse> {
        /**
         * <p>
         * A list that contains status of the specified recorders.
         * </p>
         * 
         * @param configurationRecordersStatus
         *        A list that contains status of the specified recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecordersStatus(Collection<ConfigurationRecorderStatus> configurationRecordersStatus);

        /**
         * <p>
         * A list that contains status of the specified recorders.
         * </p>
         * 
         * @param configurationRecordersStatus
         *        A list that contains status of the specified recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecordersStatus(ConfigurationRecorderStatus... configurationRecordersStatus);

        /**
         * <p>
         * A list that contains status of the specified recorders.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationRecorderStatus>.Builder}
         * avoiding the need to create one manually via {@link List<ConfigurationRecorderStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationRecorderStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #configurationRecordersStatus(List<ConfigurationRecorderStatus>)}.
         * 
         * @param configurationRecordersStatus
         *        a consumer that will call methods on {@link List<ConfigurationRecorderStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationRecordersStatus(List<ConfigurationRecorderStatus>)
         */
        Builder configurationRecordersStatus(Consumer<ConfigurationRecorderStatus.Builder>... configurationRecordersStatus);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConfigurationRecorderStatus> configurationRecordersStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecorderStatusResponse model) {
            super(model);
            configurationRecordersStatus(model.configurationRecordersStatus);
        }

        public final Collection<ConfigurationRecorderStatus.Builder> getConfigurationRecordersStatus() {
            return configurationRecordersStatus != null ? configurationRecordersStatus.stream()
                    .map(ConfigurationRecorderStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationRecordersStatus(Collection<ConfigurationRecorderStatus> configurationRecordersStatus) {
            this.configurationRecordersStatus = ConfigurationRecorderStatusListCopier.copy(configurationRecordersStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecordersStatus(ConfigurationRecorderStatus... configurationRecordersStatus) {
            configurationRecordersStatus(Arrays.asList(configurationRecordersStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecordersStatus(
                Consumer<ConfigurationRecorderStatus.Builder>... configurationRecordersStatus) {
            configurationRecordersStatus(Stream.of(configurationRecordersStatus)
                    .map(c -> ConfigurationRecorderStatus.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationRecordersStatus(
                Collection<ConfigurationRecorderStatus.BuilderImpl> configurationRecordersStatus) {
            this.configurationRecordersStatus = ConfigurationRecorderStatusListCopier
                    .copyFromBuilder(configurationRecordersStatus);
        }

        @Override
        public DescribeConfigurationRecorderStatusResponse build() {
            return new DescribeConfigurationRecorderStatusResponse(this);
        }
    }
}
