/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDiscoveredResourceCountsResponse extends ConfigResponse implements
        ToCopyableBuilder<GetDiscoveredResourceCountsResponse.Builder, GetDiscoveredResourceCountsResponse> {
    private final Long totalDiscoveredResources;

    private final List<ResourceCount> resourceCounts;

    private final String nextToken;

    private GetDiscoveredResourceCountsResponse(BuilderImpl builder) {
        super(builder);
        this.totalDiscoveredResources = builder.totalDiscoveredResources;
        this.resourceCounts = builder.resourceCounts;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The total number of resources that AWS Config is recording in the region for your account. If you specify
     * resource types in the request, AWS Config returns only the total number of resources for those resource types.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20
     * IAM users, and 15 S3 buckets, for a total of 60 resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
     * <code>"AWS::EC2::Instances"</code> in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Config returns 25 for <code>totalDiscoveredResources</code>.
     * </p>
     * </li>
     * </ol>
     * 
     * @return The total number of resources that AWS Config is recording in the region for your account. If you specify
     *         resource types in the request, AWS Config returns only the total number of resources for those resource
     *         types.</p>
     *         <p class="title">
     *         <b>Example</b>
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2
     *         instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
     *         <code>"AWS::EC2::Instances"</code> in the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AWS Config returns 25 for <code>totalDiscoveredResources</code>.
     *         </p>
     *         </li>
     */
    public Long totalDiscoveredResources() {
        return totalDiscoveredResources;
    }

    /**
     * <p>
     * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
     * resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number
     *         of resources.
     */
    public List<ResourceCount> resourceCounts() {
        return resourceCounts;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalDiscoveredResources());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoveredResourceCountsResponse)) {
            return false;
        }
        GetDiscoveredResourceCountsResponse other = (GetDiscoveredResourceCountsResponse) obj;
        return Objects.equals(totalDiscoveredResources(), other.totalDiscoveredResources())
                && Objects.equals(resourceCounts(), other.resourceCounts()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDiscoveredResourceCountsResponse")
                .add("TotalDiscoveredResources", totalDiscoveredResources()).add("ResourceCounts", resourceCounts())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalDiscoveredResources":
            return Optional.of(clazz.cast(totalDiscoveredResources()));
        case "resourceCounts":
            return Optional.of(clazz.cast(resourceCounts()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, GetDiscoveredResourceCountsResponse> {
        /**
         * <p>
         * The total number of resources that AWS Config is recording in the region for your account. If you specify
         * resource types in the request, AWS Config returns only the total number of resources for those resource
         * types.
         * </p>
         * <p class="title">
         * <b>Example</b>
         * </p>
         * <ol>
         * <li>
         * <p>
         * AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances,
         * 20 IAM users, and 15 S3 buckets, for a total of 60 resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
         * <code>"AWS::EC2::Instances"</code> in the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * AWS Config returns 25 for <code>totalDiscoveredResources</code>.
         * </p>
         * </li>
         * </ol>
         * 
         * @param totalDiscoveredResources
         *        The total number of resources that AWS Config is recording in the region for your account. If you
         *        specify resource types in the request, AWS Config returns only the total number of resources for those
         *        resource types.</p>
         *        <p class="title">
         *        <b>Example</b>
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2
         *        instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
         *        <code>"AWS::EC2::Instances"</code> in the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AWS Config returns 25 for <code>totalDiscoveredResources</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDiscoveredResources(Long totalDiscoveredResources);

        /**
         * <p>
         * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
         * resources.
         * </p>
         * 
         * @param resourceCounts
         *        The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the
         *        number of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCounts(Collection<ResourceCount> resourceCounts);

        /**
         * <p>
         * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
         * resources.
         * </p>
         * 
         * @param resourceCounts
         *        The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the
         *        number of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCounts(ResourceCount... resourceCounts);

        /**
         * <p>
         * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
         * resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceCount>.Builder} avoiding the need
         * to create one manually via {@link List<ResourceCount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceCount>.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceCounts(List<ResourceCount>)}.
         * 
         * @param resourceCounts
         *        a consumer that will call methods on {@link List<ResourceCount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCounts(List<ResourceCount>)
         */
        Builder resourceCounts(Consumer<ResourceCount.Builder>... resourceCounts);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private Long totalDiscoveredResources;

        private List<ResourceCount> resourceCounts;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiscoveredResourceCountsResponse model) {
            super(model);
            totalDiscoveredResources(model.totalDiscoveredResources);
            resourceCounts(model.resourceCounts);
            nextToken(model.nextToken);
        }

        public final Long getTotalDiscoveredResources() {
            return totalDiscoveredResources;
        }

        @Override
        public final Builder totalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
            return this;
        }

        public final void setTotalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
        }

        public final Collection<ResourceCount.Builder> getResourceCounts() {
            return resourceCounts != null ? resourceCounts.stream().map(ResourceCount::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder resourceCounts(Collection<ResourceCount> resourceCounts) {
            this.resourceCounts = ResourceCountsCopier.copy(resourceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCounts(ResourceCount... resourceCounts) {
            resourceCounts(Arrays.asList(resourceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCounts(Consumer<ResourceCount.Builder>... resourceCounts) {
            resourceCounts(Stream.of(resourceCounts).map(c -> ResourceCount.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceCounts(Collection<ResourceCount.BuilderImpl> resourceCounts) {
            this.resourceCounts = ResourceCountsCopier.copyFromBuilder(resourceCounts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetDiscoveredResourceCountsResponse build() {
            return new GetDiscoveredResourceCountsResponse(this);
        }
    }
}
