/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDiscoveredResourcesResponse extends ConfigResponse implements
        ToCopyableBuilder<ListDiscoveredResourcesResponse.Builder, ListDiscoveredResourcesResponse> {
    private final List<ResourceIdentifier> resourceIdentifiers;

    private final String nextToken;

    private ListDiscoveredResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The details that identify a resource that is discovered by AWS Config, including the resource type, ID, and (if
     * available) the custom resource name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The details that identify a resource that is discovered by AWS Config, including the resource type, ID,
     *         and (if available) the custom resource name.
     */
    public List<ResourceIdentifier> resourceIdentifiers() {
        return resourceIdentifiers;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesResponse)) {
            return false;
        }
        ListDiscoveredResourcesResponse other = (ListDiscoveredResourcesResponse) obj;
        return Objects.equals(resourceIdentifiers(), other.resourceIdentifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListDiscoveredResourcesResponse").add("ResourceIdentifiers", resourceIdentifiers())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceIdentifiers":
            return Optional.of(clazz.cast(resourceIdentifiers()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, ListDiscoveredResourcesResponse> {
        /**
         * <p>
         * The details that identify a resource that is discovered by AWS Config, including the resource type, ID, and
         * (if available) the custom resource name.
         * </p>
         * 
         * @param resourceIdentifiers
         *        The details that identify a resource that is discovered by AWS Config, including the resource type,
         *        ID, and (if available) the custom resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers);

        /**
         * <p>
         * The details that identify a resource that is discovered by AWS Config, including the resource type, ID, and
         * (if available) the custom resource name.
         * </p>
         * 
         * @param resourceIdentifiers
         *        The details that identify a resource that is discovered by AWS Config, including the resource type,
         *        ID, and (if available) the custom resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(ResourceIdentifier... resourceIdentifiers);

        /**
         * <p>
         * The details that identify a resource that is discovered by AWS Config, including the resource type, ID, and
         * (if available) the custom resource name.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceIdentifier>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceIdentifier>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceIdentifiers(List<ResourceIdentifier>)}.
         * 
         * @param resourceIdentifiers
         *        a consumer that will call methods on {@link List<ResourceIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifiers(List<ResourceIdentifier>)
         */
        Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder>... resourceIdentifiers);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ResourceIdentifier> resourceIdentifiers;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesResponse model) {
            super(model);
            resourceIdentifiers(model.resourceIdentifiers);
            nextToken(model.nextToken);
        }

        public final Collection<ResourceIdentifier.Builder> getResourceIdentifiers() {
            return resourceIdentifiers != null ? resourceIdentifiers.stream().map(ResourceIdentifier::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(ResourceIdentifier... resourceIdentifiers) {
            resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder>... resourceIdentifiers) {
            resourceIdentifiers(Stream.of(resourceIdentifiers).map(c -> ResourceIdentifier.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceIdentifiers(Collection<ResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copyFromBuilder(resourceIdentifiers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDiscoveredResourcesResponse build() {
            return new ListDiscoveredResourcesResponse(this);
        }
    }
}
