/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ResourceCountMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the resource type and the number of resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceCount implements StructuredPojo, ToCopyableBuilder<ResourceCount.Builder, ResourceCount> {
    private final String resourceType;

    private final Long count;

    private ResourceCount(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.count = builder.count;
    }

    /**
     * <p>
     * The resource type, for example <code>"AWS::EC2::Instance"</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type, for example <code>"AWS::EC2::Instance"</code>.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type, for example <code>"AWS::EC2::Instance"</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type, for example <code>"AWS::EC2::Instance"</code>.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The number of resources.
     * </p>
     * 
     * @return The number of resources.
     */
    public Long count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCount)) {
            return false;
        }
        ResourceCount other = (ResourceCount) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(count(), other.count());
    }

    @Override
    public String toString() {
        return ToString.builder("ResourceCount").add("ResourceType", resourceTypeAsString()).add("Count", count()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.of(clazz.cast(resourceTypeAsString()));
        case "count":
            return Optional.of(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceCountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceCount> {
        /**
         * <p>
         * The resource type, for example <code>"AWS::EC2::Instance"</code>.
         * </p>
         * 
         * @param resourceType
         *        The resource type, for example <code>"AWS::EC2::Instance"</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type, for example <code>"AWS::EC2::Instance"</code>.
         * </p>
         * 
         * @param resourceType
         *        The resource type, for example <code>"AWS::EC2::Instance"</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The number of resources.
         * </p>
         * 
         * @param count
         *        The number of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private Long count;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCount model) {
            resourceType(model.resourceType);
            count(model.count);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Long getCount() {
            return count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public ResourceCount build() {
            return new ResourceCount(this);
        }
    }
}
