/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.EvaluationResultIdentifier;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link EvaluationResultIdentifier} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class EvaluationResultIdentifierMarshaller {
    private static final MarshallingInfo<StructuredPojo> EVALUATIONRESULTQUALIFIER_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EvaluationResultQualifier").isBinary(false).build();

    private static final MarshallingInfo<Instant> ORDERINGTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderingTimestamp").isBinary(false).build();

    private static final EvaluationResultIdentifierMarshaller INSTANCE = new EvaluationResultIdentifierMarshaller();

    private EvaluationResultIdentifierMarshaller() {
    }

    public static EvaluationResultIdentifierMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(EvaluationResultIdentifier evaluationResultIdentifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(evaluationResultIdentifier, "evaluationResultIdentifier");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller
                    .marshall(evaluationResultIdentifier.evaluationResultQualifier(), EVALUATIONRESULTQUALIFIER_BINDING);
            protocolMarshaller.marshall(evaluationResultIdentifier.orderingTimestamp(), ORDERINGTIMESTAMP_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
