/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>GetResourceConfigHistory</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceConfigHistoryRequest extends ConfigRequest implements
        ToCopyableBuilder<GetResourceConfigHistoryRequest.Builder, GetResourceConfigHistoryRequest> {
    private final String resourceType;

    private final String resourceId;

    private final Instant laterTime;

    private final Instant earlierTime;

    private final String chronologicalOrder;

    private final Integer limit;

    private final String nextToken;

    private GetResourceConfigHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.laterTime = builder.laterTime;
        this.earlierTime = builder.earlierTime;
        this.chronologicalOrder = builder.chronologicalOrder;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource (for example., <code>sg-xxxxxx</code>).
     * </p>
     * 
     * @return The ID of the resource (for example., <code>sg-xxxxxx</code>).
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The time stamp that indicates a later time. If not specified, current time is taken.
     * </p>
     * 
     * @return The time stamp that indicates a later time. If not specified, current time is taken.
     */
    public Instant laterTime() {
        return laterTime;
    }

    /**
     * <p>
     * The time stamp that indicates an earlier time. If not specified, the action returns paginated results that
     * contain configuration items that start from when the first configuration item was recorded.
     * </p>
     * 
     * @return The time stamp that indicates an earlier time. If not specified, the action returns paginated results
     *         that contain configuration items that start from when the first configuration item was recorded.
     */
    public Instant earlierTime() {
        return earlierTime;
    }

    /**
     * <p>
     * The chronological order for configuration items listed. By default the results are listed in reverse
     * chronological order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #chronologicalOrder} will return {@link ChronologicalOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #chronologicalOrderAsString}.
     * </p>
     * 
     * @return The chronological order for configuration items listed. By default the results are listed in reverse
     *         chronological order.
     * @see ChronologicalOrder
     */
    public ChronologicalOrder chronologicalOrder() {
        return ChronologicalOrder.fromValue(chronologicalOrder);
    }

    /**
     * <p>
     * The chronological order for configuration items listed. By default the results are listed in reverse
     * chronological order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #chronologicalOrder} will return {@link ChronologicalOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #chronologicalOrderAsString}.
     * </p>
     * 
     * @return The chronological order for configuration items listed. By default the results are listed in reverse
     *         chronological order.
     * @see ChronologicalOrder
     */
    public String chronologicalOrderAsString() {
        return chronologicalOrder;
    }

    /**
     * <p>
     * The maximum number of configuration items returned on each page. The default is 10. You cannot specify a limit
     * greater than 100. If you specify 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of configuration items returned on each page. The default is 10. You cannot specify a
     *         limit greater than 100. If you specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(laterTime());
        hashCode = 31 * hashCode + Objects.hashCode(earlierTime());
        hashCode = 31 * hashCode + Objects.hashCode(chronologicalOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigHistoryRequest)) {
            return false;
        }
        GetResourceConfigHistoryRequest other = (GetResourceConfigHistoryRequest) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(laterTime(), other.laterTime())
                && Objects.equals(earlierTime(), other.earlierTime())
                && Objects.equals(chronologicalOrderAsString(), other.chronologicalOrderAsString())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetResourceConfigHistoryRequest").add("ResourceType", resourceTypeAsString())
                .add("ResourceId", resourceId()).add("LaterTime", laterTime()).add("EarlierTime", earlierTime())
                .add("ChronologicalOrder", chronologicalOrderAsString()).add("Limit", limit()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "laterTime":
            return Optional.ofNullable(clazz.cast(laterTime()));
        case "earlierTime":
            return Optional.ofNullable(clazz.cast(earlierTime()));
        case "chronologicalOrder":
            return Optional.ofNullable(clazz.cast(chronologicalOrderAsString()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, GetResourceConfigHistoryRequest> {
        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The ID of the resource (for example., <code>sg-xxxxxx</code>).
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource (for example., <code>sg-xxxxxx</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The time stamp that indicates a later time. If not specified, current time is taken.
         * </p>
         * 
         * @param laterTime
         *        The time stamp that indicates a later time. If not specified, current time is taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder laterTime(Instant laterTime);

        /**
         * <p>
         * The time stamp that indicates an earlier time. If not specified, the action returns paginated results that
         * contain configuration items that start from when the first configuration item was recorded.
         * </p>
         * 
         * @param earlierTime
         *        The time stamp that indicates an earlier time. If not specified, the action returns paginated results
         *        that contain configuration items that start from when the first configuration item was recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earlierTime(Instant earlierTime);

        /**
         * <p>
         * The chronological order for configuration items listed. By default the results are listed in reverse
         * chronological order.
         * </p>
         * 
         * @param chronologicalOrder
         *        The chronological order for configuration items listed. By default the results are listed in reverse
         *        chronological order.
         * @see ChronologicalOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChronologicalOrder
         */
        Builder chronologicalOrder(String chronologicalOrder);

        /**
         * <p>
         * The chronological order for configuration items listed. By default the results are listed in reverse
         * chronological order.
         * </p>
         * 
         * @param chronologicalOrder
         *        The chronological order for configuration items listed. By default the results are listed in reverse
         *        chronological order.
         * @see ChronologicalOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChronologicalOrder
         */
        Builder chronologicalOrder(ChronologicalOrder chronologicalOrder);

        /**
         * <p>
         * The maximum number of configuration items returned on each page. The default is 10. You cannot specify a
         * limit greater than 100. If you specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of configuration items returned on each page. The default is 10. You cannot specify
         *        a limit greater than 100. If you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private Instant laterTime;

        private Instant earlierTime;

        private String chronologicalOrder;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigHistoryRequest model) {
            super(model);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            laterTime(model.laterTime);
            earlierTime(model.earlierTime);
            chronologicalOrder(model.chronologicalOrder);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Instant getLaterTime() {
            return laterTime;
        }

        @Override
        public final Builder laterTime(Instant laterTime) {
            this.laterTime = laterTime;
            return this;
        }

        public final void setLaterTime(Instant laterTime) {
            this.laterTime = laterTime;
        }

        public final Instant getEarlierTime() {
            return earlierTime;
        }

        @Override
        public final Builder earlierTime(Instant earlierTime) {
            this.earlierTime = earlierTime;
            return this;
        }

        public final void setEarlierTime(Instant earlierTime) {
            this.earlierTime = earlierTime;
        }

        public final String getChronologicalOrder() {
            return chronologicalOrder;
        }

        @Override
        public final Builder chronologicalOrder(String chronologicalOrder) {
            this.chronologicalOrder = chronologicalOrder;
            return this;
        }

        @Override
        public final Builder chronologicalOrder(ChronologicalOrder chronologicalOrder) {
            this.chronologicalOrder(chronologicalOrder.toString());
            return this;
        }

        public final void setChronologicalOrder(String chronologicalOrder) {
            this.chronologicalOrder = chronologicalOrder;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceConfigHistoryRequest build() {
            return new GetResourceConfigHistoryRequest(this);
        }
    }
}
