/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigRuleRequest extends ConfigRequest implements
        ToCopyableBuilder<PutConfigRuleRequest.Builder, PutConfigRuleRequest> {
    private final ConfigRule configRule;

    private PutConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configRule = builder.configRule;
    }

    /**
     * <p>
     * The rule that you want to add to your account.
     * </p>
     * 
     * @return The rule that you want to add to your account.
     */
    public ConfigRule configRule() {
        return configRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRule());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigRuleRequest)) {
            return false;
        }
        PutConfigRuleRequest other = (PutConfigRuleRequest) obj;
        return Objects.equals(configRule(), other.configRule());
    }

    @Override
    public String toString() {
        return ToString.builder("PutConfigRuleRequest").add("ConfigRule", configRule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRule":
            return Optional.ofNullable(clazz.cast(configRule()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, PutConfigRuleRequest> {
        /**
         * <p>
         * The rule that you want to add to your account.
         * </p>
         * 
         * @param configRule
         *        The rule that you want to add to your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRule(ConfigRule configRule);

        /**
         * <p>
         * The rule that you want to add to your account.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigRule.Builder} avoiding the need to create
         * one manually via {@link ConfigRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigRule.Builder#build()} is called immediately and its result
         * is passed to {@link #configRule(ConfigRule)}.
         * 
         * @param configRule
         *        a consumer that will call methods on {@link ConfigRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configRule(ConfigRule)
         */
        default Builder configRule(Consumer<ConfigRule.Builder> configRule) {
            return configRule(ConfigRule.builder().applyMutation(configRule).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private ConfigRule configRule;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigRuleRequest model) {
            super(model);
            configRule(model.configRule);
        }

        public final ConfigRule.Builder getConfigRule() {
            return configRule != null ? configRule.toBuilder() : null;
        }

        @Override
        public final Builder configRule(ConfigRule configRule) {
            this.configRule = configRule;
            return this;
        }

        public final void setConfigRule(ConfigRule.BuilderImpl configRule) {
            this.configRule = configRule != null ? configRule.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigRuleRequest build() {
            return new PutConfigRuleRequest(this);
        }
    }
}
