/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceSummary;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ComplianceSummary} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ComplianceSummaryMarshaller {
    private static final MarshallingInfo<StructuredPojo> COMPLIANTRESOURCECOUNT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CompliantResourceCount").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NONCOMPLIANTRESOURCECOUNT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NonCompliantResourceCount").isBinary(false).build();

    private static final MarshallingInfo<Instant> COMPLIANCESUMMARYTIMESTAMP_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ComplianceSummaryTimestamp").isBinary(false).build();

    private static final ComplianceSummaryMarshaller INSTANCE = new ComplianceSummaryMarshaller();

    private ComplianceSummaryMarshaller() {
    }

    public static ComplianceSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ComplianceSummary complianceSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(complianceSummary, "complianceSummary");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(complianceSummary.compliantResourceCount(), COMPLIANTRESOURCECOUNT_BINDING);
            protocolMarshaller.marshall(complianceSummary.nonCompliantResourceCount(), NONCOMPLIANTRESOURCECOUNT_BINDING);
            protocolMarshaller.marshall(complianceSummary.complianceSummaryTimestamp(), COMPLIANCESUMMARYTIMESTAMP_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
