/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ConfigRuleEvaluationStatus} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ConfigRuleEvaluationStatusMarshaller {
    private static final MarshallingInfo<String> CONFIGRULENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleName").isBinary(false).build();

    private static final MarshallingInfo<String> CONFIGRULEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleArn").isBinary(false).build();

    private static final MarshallingInfo<String> CONFIGRULEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleId").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTSUCCESSFULINVOCATIONTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastSuccessfulInvocationTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTFAILEDINVOCATIONTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastFailedInvocationTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTSUCCESSFULEVALUATIONTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastSuccessfulEvaluationTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTFAILEDEVALUATIONTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastFailedEvaluationTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> FIRSTACTIVATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirstActivatedTime").isBinary(false).build();

    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastErrorCode").isBinary(false).build();

    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastErrorMessage").isBinary(false).build();

    private static final MarshallingInfo<Boolean> FIRSTEVALUATIONSTARTED_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("FirstEvaluationStarted").isBinary(false).build();

    private static final ConfigRuleEvaluationStatusMarshaller INSTANCE = new ConfigRuleEvaluationStatusMarshaller();

    private ConfigRuleEvaluationStatusMarshaller() {
    }

    public static ConfigRuleEvaluationStatusMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ConfigRuleEvaluationStatus configRuleEvaluationStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(configRuleEvaluationStatus, "configRuleEvaluationStatus");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(configRuleEvaluationStatus.configRuleName(), CONFIGRULENAME_BINDING);
            protocolMarshaller.marshall(configRuleEvaluationStatus.configRuleArn(), CONFIGRULEARN_BINDING);
            protocolMarshaller.marshall(configRuleEvaluationStatus.configRuleId(), CONFIGRULEID_BINDING);
            protocolMarshaller.marshall(configRuleEvaluationStatus.lastSuccessfulInvocationTime(),
                    LASTSUCCESSFULINVOCATIONTIME_BINDING);
            protocolMarshaller.marshall(configRuleEvaluationStatus.lastFailedInvocationTime(), LASTFAILEDINVOCATIONTIME_BINDING);
            protocolMarshaller.marshall(configRuleEvaluationStatus.lastSuccessfulEvaluationTime(),
                    LASTSUCCESSFULEVALUATIONTIME_BINDING);
            protocolMarshaller.marshall(configRuleEvaluationStatus.lastFailedEvaluationTime(), LASTFAILEDEVALUATIONTIME_BINDING);
            protocolMarshaller.marshall(configRuleEvaluationStatus.firstActivatedTime(), FIRSTACTIVATEDTIME_BINDING);
            protocolMarshaller.marshall(configRuleEvaluationStatus.lastErrorCode(), LASTERRORCODE_BINDING);
            protocolMarshaller.marshall(configRuleEvaluationStatus.lastErrorMessage(), LASTERRORMESSAGE_BINDING);
            protocolMarshaller.marshall(configRuleEvaluationStatus.firstEvaluationStarted(), FIRSTEVALUATIONSTARTED_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
