/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.EvaluationResult;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link EvaluationResult} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class EvaluationResultMarshaller {
    private static final MarshallingInfo<StructuredPojo> EVALUATIONRESULTIDENTIFIER_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EvaluationResultIdentifier").isBinary(false).build();

    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").isBinary(false).build();

    private static final MarshallingInfo<Instant> RESULTRECORDEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultRecordedTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> CONFIGRULEINVOKEDTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ConfigRuleInvokedTime").isBinary(false).build();

    private static final MarshallingInfo<String> ANNOTATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Annotation").isBinary(false).build();

    private static final MarshallingInfo<String> RESULTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultToken").isBinary(false).build();

    private static final EvaluationResultMarshaller INSTANCE = new EvaluationResultMarshaller();

    private EvaluationResultMarshaller() {
    }

    public static EvaluationResultMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(EvaluationResult evaluationResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(evaluationResult, "evaluationResult");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(evaluationResult.evaluationResultIdentifier(), EVALUATIONRESULTIDENTIFIER_BINDING);
            protocolMarshaller.marshall(evaluationResult.complianceTypeAsString(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall(evaluationResult.resultRecordedTime(), RESULTRECORDEDTIME_BINDING);
            protocolMarshaller.marshall(evaluationResult.configRuleInvokedTime(), CONFIGRULEINVOKEDTIME_BINDING);
            protocolMarshaller.marshall(evaluationResult.annotation(), ANNOTATION_BINDING);
            protocolMarshaller.marshall(evaluationResult.resultToken(), RESULTTOKEN_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
