/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceContributorCount;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.transform.ComplianceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Compliance
implements StructuredPojo,
ToCopyableBuilder<Builder, Compliance> {
    private final String complianceType;
    private final ComplianceContributorCount complianceContributorCount;

    private Compliance(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.complianceContributorCount = builder.complianceContributorCount;
    }

    public ComplianceType complianceType() {
        return ComplianceType.fromValue(this.complianceType);
    }

    public String complianceTypeAsString() {
        return this.complianceType;
    }

    public ComplianceContributorCount complianceContributorCount() {
        return this.complianceContributorCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceContributorCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compliance)) {
            return false;
        }
        Compliance other = (Compliance)obj;
        return Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && Objects.equals(this.complianceContributorCount(), other.complianceContributorCount());
    }

    public String toString() {
        return ToString.builder((String)"Compliance").add("ComplianceType", (Object)this.complianceTypeAsString()).add("ComplianceContributorCount", (Object)this.complianceContributorCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "ComplianceContributorCount": {
                return Optional.ofNullable(clazz.cast(this.complianceContributorCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private ComplianceContributorCount complianceContributorCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Compliance model) {
            this.complianceType(model.complianceType);
            this.complianceContributorCount(model.complianceContributorCount);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final ComplianceContributorCount.Builder getComplianceContributorCount() {
            return this.complianceContributorCount != null ? this.complianceContributorCount.toBuilder() : null;
        }

        @Override
        public final Builder complianceContributorCount(ComplianceContributorCount complianceContributorCount) {
            this.complianceContributorCount = complianceContributorCount;
            return this;
        }

        public final void setComplianceContributorCount(ComplianceContributorCount.BuilderImpl complianceContributorCount) {
            this.complianceContributorCount = complianceContributorCount != null ? complianceContributorCount.build() : null;
        }

        public Compliance build() {
            return new Compliance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Compliance> {
        public Builder complianceType(String var1);

        public Builder complianceType(ComplianceType var1);

        public Builder complianceContributorCount(ComplianceContributorCount var1);

        default public Builder complianceContributorCount(Consumer<ComplianceContributorCount.Builder> complianceContributorCount) {
            return this.complianceContributorCount((ComplianceContributorCount)((ComplianceContributorCount.Builder)ComplianceContributorCount.builder().applyMutation(complianceContributorCount)).build());
        }
    }
}

