/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ResourceIdentifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceIdentifierMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").isBinary(false).build();
    private static final MarshallingInfo<Instant> RESOURCEDELETIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceDeletionTime").isBinary(false).build();
    private static final ResourceIdentifierMarshaller INSTANCE = new ResourceIdentifierMarshaller();

    private ResourceIdentifierMarshaller() {
    }

    public static ResourceIdentifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceIdentifier resourceIdentifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceIdentifier, (String)"resourceIdentifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceIdentifier.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.resourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.resourceDeletionTime(), RESOURCEDELETIONTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

