/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.AggregateComplianceCountMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateComplianceCount implements StructuredPojo,
        ToCopyableBuilder<AggregateComplianceCount.Builder, AggregateComplianceCount> {
    private final String groupName;

    private final ComplianceSummary complianceSummary;

    private AggregateComplianceCount(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.complianceSummary = builder.complianceSummary;
    }

    /**
     * <p>
     * The 12-digit account ID or region based on the GroupByKey value.
     * </p>
     * 
     * @return The 12-digit account ID or region based on the GroupByKey value.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The number of compliant and noncompliant AWS Config rules.
     * </p>
     * 
     * @return The number of compliant and noncompliant AWS Config rules.
     */
    public ComplianceSummary complianceSummary() {
        return complianceSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(complianceSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateComplianceCount)) {
            return false;
        }
        AggregateComplianceCount other = (AggregateComplianceCount) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(complianceSummary(), other.complianceSummary());
    }

    @Override
    public String toString() {
        return ToString.builder("AggregateComplianceCount").add("GroupName", groupName())
                .add("ComplianceSummary", complianceSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "ComplianceSummary":
            return Optional.ofNullable(clazz.cast(complianceSummary()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AggregateComplianceCountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AggregateComplianceCount> {
        /**
         * <p>
         * The 12-digit account ID or region based on the GroupByKey value.
         * </p>
         * 
         * @param groupName
         *        The 12-digit account ID or region based on the GroupByKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The number of compliant and noncompliant AWS Config rules.
         * </p>
         * 
         * @param complianceSummary
         *        The number of compliant and noncompliant AWS Config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummary(ComplianceSummary complianceSummary);

        /**
         * <p>
         * The number of compliant and noncompliant AWS Config rules.
         * </p>
         * This is a convenience that creates an instance of the {@link ComplianceSummary.Builder} avoiding the need to
         * create one manually via {@link ComplianceSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComplianceSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #complianceSummary(ComplianceSummary)}.
         * 
         * @param complianceSummary
         *        a consumer that will call methods on {@link ComplianceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceSummary(ComplianceSummary)
         */
        default Builder complianceSummary(Consumer<ComplianceSummary.Builder> complianceSummary) {
            return complianceSummary(ComplianceSummary.builder().applyMutation(complianceSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private ComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateComplianceCount model) {
            groupName(model.groupName);
            complianceSummary(model.complianceSummary);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final ComplianceSummary.Builder getComplianceSummary() {
            return complianceSummary != null ? complianceSummary.toBuilder() : null;
        }

        @Override
        public final Builder complianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final void setComplianceSummary(ComplianceSummary.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        @Override
        public AggregateComplianceCount build() {
            return new AggregateComplianceCount(this);
        }
    }
}
