/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ComplianceByConfigRuleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether an AWS Config rule is compliant. A rule is compliant if all of the resources that the rule
 * evaluated comply with it. A rule is noncompliant if any of these resources do not comply.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComplianceByConfigRule implements StructuredPojo,
        ToCopyableBuilder<ComplianceByConfigRule.Builder, ComplianceByConfigRule> {
    private final String configRuleName;

    private final Compliance compliance;

    private ComplianceByConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.compliance = builder.compliance;
    }

    /**
     * <p>
     * The name of the AWS Config rule.
     * </p>
     * 
     * @return The name of the AWS Config rule.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * Indicates whether the AWS Config rule is compliant.
     * </p>
     * 
     * @return Indicates whether the AWS Config rule is compliant.
     */
    public Compliance compliance() {
        return compliance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(compliance());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceByConfigRule)) {
            return false;
        }
        ComplianceByConfigRule other = (ComplianceByConfigRule) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(compliance(), other.compliance());
    }

    @Override
    public String toString() {
        return ToString.builder("ComplianceByConfigRule").add("ConfigRuleName", configRuleName()).add("Compliance", compliance())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "Compliance":
            return Optional.ofNullable(clazz.cast(compliance()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceByConfigRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComplianceByConfigRule> {
        /**
         * <p>
         * The name of the AWS Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * Indicates whether the AWS Config rule is compliant.
         * </p>
         * 
         * @param compliance
         *        Indicates whether the AWS Config rule is compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(Compliance compliance);

        /**
         * <p>
         * Indicates whether the AWS Config rule is compliant.
         * </p>
         * This is a convenience that creates an instance of the {@link Compliance.Builder} avoiding the need to create
         * one manually via {@link Compliance#builder()}.
         *
         * When the {@link Consumer} completes, {@link Compliance.Builder#build()} is called immediately and its result
         * is passed to {@link #compliance(Compliance)}.
         * 
         * @param compliance
         *        a consumer that will call methods on {@link Compliance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compliance(Compliance)
         */
        default Builder compliance(Consumer<Compliance.Builder> compliance) {
            return compliance(Compliance.builder().applyMutation(compliance).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private Compliance compliance;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceByConfigRule model) {
            configRuleName(model.configRuleName);
            compliance(model.compliance);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final Compliance.Builder getCompliance() {
            return compliance != null ? compliance.toBuilder() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        @Override
        public ComplianceByConfigRule build() {
            return new ComplianceByConfigRule(this);
        }
    }
}
