/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ConfigRuleComplianceFiltersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters the compliance results based on account ID, region, compliance type, and rule name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigRuleComplianceFilters implements StructuredPojo,
        ToCopyableBuilder<ConfigRuleComplianceFilters.Builder, ConfigRuleComplianceFilters> {
    private final String configRuleName;

    private final String complianceType;

    private final String accountId;

    private final String awsRegion;

    private ConfigRuleComplianceFilters(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.complianceType = builder.complianceType;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    /**
     * <p>
     * The name of the AWS Config rule.
     * </p>
     * 
     * @return The name of the AWS Config rule.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The rule compliance status.
     * </p>
     * <p>
     * For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only <code>COMPLIANT</code> and
     * <code>NON_COMPLIANT</code>. AWS Config does not support the <code>NOT_APPLICABLE</code> and the
     * <code>INSUFFICIENT_DATA</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The rule compliance status.</p>
     *         <p>
     *         For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only
     *         <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
     *         <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.
     * @see ComplianceType
     */
    public ComplianceType complianceType() {
        return ComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * The rule compliance status.
     * </p>
     * <p>
     * For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only <code>COMPLIANT</code> and
     * <code>NON_COMPLIANT</code>. AWS Config does not support the <code>NOT_APPLICABLE</code> and the
     * <code>INSUFFICIENT_DATA</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The rule compliance status.</p>
     *         <p>
     *         For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only
     *         <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
     *         <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.
     * @see ComplianceType
     */
    public String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * <p>
     * The 12-digit account ID of the source account.
     * </p>
     * 
     * @return The 12-digit account ID of the source account.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The source region where the data is aggregated.
     * </p>
     * 
     * @return The source region where the data is aggregated.
     */
    public String awsRegion() {
        return awsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRuleComplianceFilters)) {
            return false;
        }
        ConfigRuleComplianceFilters other = (ConfigRuleComplianceFilters) obj;
        return Objects.equals(configRuleName(), other.configRuleName())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(awsRegion(), other.awsRegion());
    }

    @Override
    public String toString() {
        return ToString.builder("ConfigRuleComplianceFilters").add("ConfigRuleName", configRuleName())
                .add("ComplianceType", complianceTypeAsString()).add("AccountId", accountId()).add("AwsRegion", awsRegion())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigRuleComplianceFiltersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ConfigRuleComplianceFilters> {
        /**
         * <p>
         * The name of the AWS Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The rule compliance status.
         * </p>
         * <p>
         * For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only <code>COMPLIANT</code>
         * and <code>NON_COMPLIANT</code>. AWS Config does not support the <code>NOT_APPLICABLE</code> and the
         * <code>INSUFFICIENT_DATA</code> values.
         * </p>
         * 
         * @param complianceType
         *        The rule compliance status.</p>
         *        <p>
         *        For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only
         *        <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
         *        <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The rule compliance status.
         * </p>
         * <p>
         * For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only <code>COMPLIANT</code>
         * and <code>NON_COMPLIANT</code>. AWS Config does not support the <code>NOT_APPLICABLE</code> and the
         * <code>INSUFFICIENT_DATA</code> values.
         * </p>
         * 
         * @param complianceType
         *        The rule compliance status.</p>
         *        <p>
         *        For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only
         *        <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
         *        <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * The 12-digit account ID of the source account.
         * </p>
         * 
         * @param accountId
         *        The 12-digit account ID of the source account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The source region where the data is aggregated.
         * </p>
         * 
         * @param awsRegion
         *        The source region where the data is aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String complianceType;

        private String accountId;

        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRuleComplianceFilters model) {
            configRuleName(model.configRuleName);
            complianceType(model.complianceType);
            accountId(model.accountId);
            awsRegion(model.awsRegion);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public ConfigRuleComplianceFilters build() {
            return new ConfigRuleComplianceFilters(this);
        }
    }
}
