/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRetentionConfigurationRequest extends ConfigRequest implements
        ToCopyableBuilder<DeleteRetentionConfigurationRequest.Builder, DeleteRetentionConfigurationRequest> {
    private final String retentionConfigurationName;

    private DeleteRetentionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.retentionConfigurationName = builder.retentionConfigurationName;
    }

    /**
     * <p>
     * The name of the retention configuration to delete.
     * </p>
     * 
     * @return The name of the retention configuration to delete.
     */
    public String retentionConfigurationName() {
        return retentionConfigurationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionConfigurationName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRetentionConfigurationRequest)) {
            return false;
        }
        DeleteRetentionConfigurationRequest other = (DeleteRetentionConfigurationRequest) obj;
        return Objects.equals(retentionConfigurationName(), other.retentionConfigurationName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteRetentionConfigurationRequest")
                .add("RetentionConfigurationName", retentionConfigurationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionConfigurationName":
            return Optional.ofNullable(clazz.cast(retentionConfigurationName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, DeleteRetentionConfigurationRequest> {
        /**
         * <p>
         * The name of the retention configuration to delete.
         * </p>
         * 
         * @param retentionConfigurationName
         *        The name of the retention configuration to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionConfigurationName(String retentionConfigurationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String retentionConfigurationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRetentionConfigurationRequest model) {
            super(model);
            retentionConfigurationName(model.retentionConfigurationName);
        }

        public final String getRetentionConfigurationName() {
            return retentionConfigurationName;
        }

        @Override
        public final Builder retentionConfigurationName(String retentionConfigurationName) {
            this.retentionConfigurationName = retentionConfigurationName;
            return this;
        }

        public final void setRetentionConfigurationName(String retentionConfigurationName) {
            this.retentionConfigurationName = retentionConfigurationName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRetentionConfigurationRequest build() {
            return new DeleteRetentionConfigurationRequest(this);
        }
    }
}
