/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAggregationAuthorizationsResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeAggregationAuthorizationsResponse.Builder, DescribeAggregationAuthorizationsResponse> {
    private final List<AggregationAuthorization> aggregationAuthorizations;

    private final String nextToken;

    private DescribeAggregationAuthorizationsResponse(BuilderImpl builder) {
        super(builder);
        this.aggregationAuthorizations = builder.aggregationAuthorizations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns a list of authorizations granted to various aggregator accounts and regions.
     */
    public List<AggregationAuthorization> aggregationAuthorizations() {
        return aggregationAuthorizations;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAuthorizations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAggregationAuthorizationsResponse)) {
            return false;
        }
        DescribeAggregationAuthorizationsResponse other = (DescribeAggregationAuthorizationsResponse) obj;
        return Objects.equals(aggregationAuthorizations(), other.aggregationAuthorizations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAggregationAuthorizationsResponse")
                .add("AggregationAuthorizations", aggregationAuthorizations()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregationAuthorizations":
            return Optional.ofNullable(clazz.cast(aggregationAuthorizations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, DescribeAggregationAuthorizationsResponse> {
        /**
         * <p>
         * Returns a list of authorizations granted to various aggregator accounts and regions.
         * </p>
         * 
         * @param aggregationAuthorizations
         *        Returns a list of authorizations granted to various aggregator accounts and regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationAuthorizations(Collection<AggregationAuthorization> aggregationAuthorizations);

        /**
         * <p>
         * Returns a list of authorizations granted to various aggregator accounts and regions.
         * </p>
         * 
         * @param aggregationAuthorizations
         *        Returns a list of authorizations granted to various aggregator accounts and regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationAuthorizations(AggregationAuthorization... aggregationAuthorizations);

        /**
         * <p>
         * Returns a list of authorizations granted to various aggregator accounts and regions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AggregationAuthorization>.Builder} avoiding
         * the need to create one manually via {@link List<AggregationAuthorization>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregationAuthorization>.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregationAuthorizations(List<AggregationAuthorization>)}.
         * 
         * @param aggregationAuthorizations
         *        a consumer that will call methods on {@link List<AggregationAuthorization>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationAuthorizations(List<AggregationAuthorization>)
         */
        Builder aggregationAuthorizations(Consumer<AggregationAuthorization.Builder>... aggregationAuthorizations);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<AggregationAuthorization> aggregationAuthorizations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAggregationAuthorizationsResponse model) {
            super(model);
            aggregationAuthorizations(model.aggregationAuthorizations);
            nextToken(model.nextToken);
        }

        public final Collection<AggregationAuthorization.Builder> getAggregationAuthorizations() {
            return aggregationAuthorizations != null ? aggregationAuthorizations.stream()
                    .map(AggregationAuthorization::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregationAuthorizations(Collection<AggregationAuthorization> aggregationAuthorizations) {
            this.aggregationAuthorizations = AggregationAuthorizationListCopier.copy(aggregationAuthorizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationAuthorizations(AggregationAuthorization... aggregationAuthorizations) {
            aggregationAuthorizations(Arrays.asList(aggregationAuthorizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationAuthorizations(Consumer<AggregationAuthorization.Builder>... aggregationAuthorizations) {
            aggregationAuthorizations(Stream.of(aggregationAuthorizations)
                    .map(c -> AggregationAuthorization.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregationAuthorizations(Collection<AggregationAuthorization.BuilderImpl> aggregationAuthorizations) {
            this.aggregationAuthorizations = AggregationAuthorizationListCopier.copyFromBuilder(aggregationAuthorizations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAggregationAuthorizationsResponse build() {
            return new DescribeAggregationAuthorizationsResponse(this);
        }
    }
}
