/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationAggregatorsResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeConfigurationAggregatorsResponse.Builder, DescribeConfigurationAggregatorsResponse> {
    private final List<ConfigurationAggregator> configurationAggregators;

    private final String nextToken;

    private DescribeConfigurationAggregatorsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationAggregators = builder.configurationAggregators;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Returns a ConfigurationAggregators object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns a ConfigurationAggregators object.
     */
    public List<ConfigurationAggregator> configurationAggregators() {
        return configurationAggregators;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregators());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationAggregatorsResponse)) {
            return false;
        }
        DescribeConfigurationAggregatorsResponse other = (DescribeConfigurationAggregatorsResponse) obj;
        return Objects.equals(configurationAggregators(), other.configurationAggregators())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationAggregatorsResponse")
                .add("ConfigurationAggregators", configurationAggregators()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregators":
            return Optional.ofNullable(clazz.cast(configurationAggregators()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, DescribeConfigurationAggregatorsResponse> {
        /**
         * <p>
         * Returns a ConfigurationAggregators object.
         * </p>
         * 
         * @param configurationAggregators
         *        Returns a ConfigurationAggregators object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregators(Collection<ConfigurationAggregator> configurationAggregators);

        /**
         * <p>
         * Returns a ConfigurationAggregators object.
         * </p>
         * 
         * @param configurationAggregators
         *        Returns a ConfigurationAggregators object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregators(ConfigurationAggregator... configurationAggregators);

        /**
         * <p>
         * Returns a ConfigurationAggregators object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationAggregator>.Builder} avoiding
         * the need to create one manually via {@link List<ConfigurationAggregator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationAggregator>.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationAggregators(List<ConfigurationAggregator>)}.
         * 
         * @param configurationAggregators
         *        a consumer that will call methods on {@link List<ConfigurationAggregator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationAggregators(List<ConfigurationAggregator>)
         */
        Builder configurationAggregators(Consumer<ConfigurationAggregator.Builder>... configurationAggregators);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConfigurationAggregator> configurationAggregators = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationAggregatorsResponse model) {
            super(model);
            configurationAggregators(model.configurationAggregators);
            nextToken(model.nextToken);
        }

        public final Collection<ConfigurationAggregator.Builder> getConfigurationAggregators() {
            return configurationAggregators != null ? configurationAggregators.stream().map(ConfigurationAggregator::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationAggregators(Collection<ConfigurationAggregator> configurationAggregators) {
            this.configurationAggregators = ConfigurationAggregatorListCopier.copy(configurationAggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationAggregators(ConfigurationAggregator... configurationAggregators) {
            configurationAggregators(Arrays.asList(configurationAggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationAggregators(Consumer<ConfigurationAggregator.Builder>... configurationAggregators) {
            configurationAggregators(Stream.of(configurationAggregators)
                    .map(c -> ConfigurationAggregator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationAggregators(Collection<ConfigurationAggregator.BuilderImpl> configurationAggregators) {
            this.configurationAggregators = ConfigurationAggregatorListCopier.copyFromBuilder(configurationAggregators);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConfigurationAggregatorsResponse build() {
            return new DescribeConfigurationAggregatorsResponse(this);
        }
    }
}
