/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeConfigurationRecorders</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationRecordersResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeConfigurationRecordersResponse.Builder, DescribeConfigurationRecordersResponse> {
    private final List<ConfigurationRecorder> configurationRecorders;

    private DescribeConfigurationRecordersResponse(BuilderImpl builder) {
        super(builder);
        this.configurationRecorders = builder.configurationRecorders;
    }

    /**
     * <p>
     * A list that contains the descriptions of the specified configuration recorders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains the descriptions of the specified configuration recorders.
     */
    public List<ConfigurationRecorder> configurationRecorders() {
        return configurationRecorders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationRecorders());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecordersResponse)) {
            return false;
        }
        DescribeConfigurationRecordersResponse other = (DescribeConfigurationRecordersResponse) obj;
        return Objects.equals(configurationRecorders(), other.configurationRecorders());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationRecordersResponse").add("ConfigurationRecorders", configurationRecorders())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorders":
            return Optional.ofNullable(clazz.cast(configurationRecorders()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, DescribeConfigurationRecordersResponse> {
        /**
         * <p>
         * A list that contains the descriptions of the specified configuration recorders.
         * </p>
         * 
         * @param configurationRecorders
         *        A list that contains the descriptions of the specified configuration recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorders(Collection<ConfigurationRecorder> configurationRecorders);

        /**
         * <p>
         * A list that contains the descriptions of the specified configuration recorders.
         * </p>
         * 
         * @param configurationRecorders
         *        A list that contains the descriptions of the specified configuration recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorders(ConfigurationRecorder... configurationRecorders);

        /**
         * <p>
         * A list that contains the descriptions of the specified configuration recorders.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationRecorder>.Builder} avoiding
         * the need to create one manually via {@link List<ConfigurationRecorder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationRecorder>.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationRecorders(List<ConfigurationRecorder>)}.
         * 
         * @param configurationRecorders
         *        a consumer that will call methods on {@link List<ConfigurationRecorder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationRecorders(List<ConfigurationRecorder>)
         */
        Builder configurationRecorders(Consumer<ConfigurationRecorder.Builder>... configurationRecorders);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConfigurationRecorder> configurationRecorders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecordersResponse model) {
            super(model);
            configurationRecorders(model.configurationRecorders);
        }

        public final Collection<ConfigurationRecorder.Builder> getConfigurationRecorders() {
            return configurationRecorders != null ? configurationRecorders.stream().map(ConfigurationRecorder::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationRecorders(Collection<ConfigurationRecorder> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copy(configurationRecorders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorders(ConfigurationRecorder... configurationRecorders) {
            configurationRecorders(Arrays.asList(configurationRecorders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorders(Consumer<ConfigurationRecorder.Builder>... configurationRecorders) {
            configurationRecorders(Stream.of(configurationRecorders)
                    .map(c -> ConfigurationRecorder.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationRecorders(Collection<ConfigurationRecorder.BuilderImpl> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copyFromBuilder(configurationRecorders);
        }

        @Override
        public DescribeConfigurationRecordersResponse build() {
            return new DescribeConfigurationRecordersResponse(this);
        }
    }
}
