/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DescribeDeliveryChannels</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeliveryChannelsRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeDeliveryChannelsRequest.Builder, DescribeDeliveryChannelsRequest> {
    private final List<String> deliveryChannelNames;

    private DescribeDeliveryChannelsRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryChannelNames = builder.deliveryChannelNames;
    }

    /**
     * <p>
     * A list of delivery channel names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of delivery channel names.
     */
    public List<String> deliveryChannelNames() {
        return deliveryChannelNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryChannelNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryChannelsRequest)) {
            return false;
        }
        DescribeDeliveryChannelsRequest other = (DescribeDeliveryChannelsRequest) obj;
        return Objects.equals(deliveryChannelNames(), other.deliveryChannelNames());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDeliveryChannelsRequest").add("DeliveryChannelNames", deliveryChannelNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryChannelNames":
            return Optional.ofNullable(clazz.cast(deliveryChannelNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, DescribeDeliveryChannelsRequest> {
        /**
         * <p>
         * A list of delivery channel names.
         * </p>
         * 
         * @param deliveryChannelNames
         *        A list of delivery channel names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannelNames(Collection<String> deliveryChannelNames);

        /**
         * <p>
         * A list of delivery channel names.
         * </p>
         * 
         * @param deliveryChannelNames
         *        A list of delivery channel names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannelNames(String... deliveryChannelNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> deliveryChannelNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryChannelsRequest model) {
            super(model);
            deliveryChannelNames(model.deliveryChannelNames);
        }

        public final Collection<String> getDeliveryChannelNames() {
            return deliveryChannelNames;
        }

        @Override
        public final Builder deliveryChannelNames(Collection<String> deliveryChannelNames) {
            this.deliveryChannelNames = DeliveryChannelNameListCopier.copy(deliveryChannelNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannelNames(String... deliveryChannelNames) {
            deliveryChannelNames(Arrays.asList(deliveryChannelNames));
            return this;
        }

        public final void setDeliveryChannelNames(Collection<String> deliveryChannelNames) {
            this.deliveryChannelNames = DeliveryChannelNameListCopier.copy(deliveryChannelNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeliveryChannelsRequest build() {
            return new DescribeDeliveryChannelsRequest(this);
        }
    }
}
