/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePendingAggregationRequestsResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribePendingAggregationRequestsResponse.Builder, DescribePendingAggregationRequestsResponse> {
    private final List<PendingAggregationRequest> pendingAggregationRequests;

    private final String nextToken;

    private DescribePendingAggregationRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.pendingAggregationRequests = builder.pendingAggregationRequests;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Returns a PendingAggregationRequests object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns a PendingAggregationRequests object.
     */
    public List<PendingAggregationRequest> pendingAggregationRequests() {
        return pendingAggregationRequests;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pendingAggregationRequests());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePendingAggregationRequestsResponse)) {
            return false;
        }
        DescribePendingAggregationRequestsResponse other = (DescribePendingAggregationRequestsResponse) obj;
        return Objects.equals(pendingAggregationRequests(), other.pendingAggregationRequests())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribePendingAggregationRequestsResponse")
                .add("PendingAggregationRequests", pendingAggregationRequests()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PendingAggregationRequests":
            return Optional.ofNullable(clazz.cast(pendingAggregationRequests()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, DescribePendingAggregationRequestsResponse> {
        /**
         * <p>
         * Returns a PendingAggregationRequests object.
         * </p>
         * 
         * @param pendingAggregationRequests
         *        Returns a PendingAggregationRequests object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingAggregationRequests(Collection<PendingAggregationRequest> pendingAggregationRequests);

        /**
         * <p>
         * Returns a PendingAggregationRequests object.
         * </p>
         * 
         * @param pendingAggregationRequests
         *        Returns a PendingAggregationRequests object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingAggregationRequests(PendingAggregationRequest... pendingAggregationRequests);

        /**
         * <p>
         * Returns a PendingAggregationRequests object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PendingAggregationRequest>.Builder}
         * avoiding the need to create one manually via {@link List<PendingAggregationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PendingAggregationRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #pendingAggregationRequests(List<PendingAggregationRequest>)}.
         * 
         * @param pendingAggregationRequests
         *        a consumer that will call methods on {@link List<PendingAggregationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingAggregationRequests(List<PendingAggregationRequest>)
         */
        Builder pendingAggregationRequests(Consumer<PendingAggregationRequest.Builder>... pendingAggregationRequests);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<PendingAggregationRequest> pendingAggregationRequests = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePendingAggregationRequestsResponse model) {
            super(model);
            pendingAggregationRequests(model.pendingAggregationRequests);
            nextToken(model.nextToken);
        }

        public final Collection<PendingAggregationRequest.Builder> getPendingAggregationRequests() {
            return pendingAggregationRequests != null ? pendingAggregationRequests.stream()
                    .map(PendingAggregationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pendingAggregationRequests(Collection<PendingAggregationRequest> pendingAggregationRequests) {
            this.pendingAggregationRequests = PendingAggregationRequestListCopier.copy(pendingAggregationRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingAggregationRequests(PendingAggregationRequest... pendingAggregationRequests) {
            pendingAggregationRequests(Arrays.asList(pendingAggregationRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingAggregationRequests(Consumer<PendingAggregationRequest.Builder>... pendingAggregationRequests) {
            pendingAggregationRequests(Stream.of(pendingAggregationRequests)
                    .map(c -> PendingAggregationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPendingAggregationRequests(
                Collection<PendingAggregationRequest.BuilderImpl> pendingAggregationRequests) {
            this.pendingAggregationRequests = PendingAggregationRequestListCopier.copyFromBuilder(pendingAggregationRequests);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePendingAggregationRequestsResponse build() {
            return new DescribePendingAggregationRequestsResponse(this);
        }
    }
}
