/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRetentionConfigurationsRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeRetentionConfigurationsRequest.Builder, DescribeRetentionConfigurationsRequest> {
    private final List<String> retentionConfigurationNames;

    private final String nextToken;

    private DescribeRetentionConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.retentionConfigurationNames = builder.retentionConfigurationNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of names of retention configurations for which you want details. If you do not specify a name, AWS Config
     * returns details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, AWS Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of names of retention configurations for which you want details. If you do not specify a name, AWS
     *         Config returns details for all the retention configurations for that account.</p> <note>
     *         <p>
     *         Currently, AWS Config supports only one retention configuration per region in your account.
     *         </p>
     */
    public List<String> retentionConfigurationNames() {
        return retentionConfigurationNames;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionConfigurationNames());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRetentionConfigurationsRequest)) {
            return false;
        }
        DescribeRetentionConfigurationsRequest other = (DescribeRetentionConfigurationsRequest) obj;
        return Objects.equals(retentionConfigurationNames(), other.retentionConfigurationNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeRetentionConfigurationsRequest")
                .add("RetentionConfigurationNames", retentionConfigurationNames()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionConfigurationNames":
            return Optional.ofNullable(clazz.cast(retentionConfigurationNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, DescribeRetentionConfigurationsRequest> {
        /**
         * <p>
         * A list of names of retention configurations for which you want details. If you do not specify a name, AWS
         * Config returns details for all the retention configurations for that account.
         * </p>
         * <note>
         * <p>
         * Currently, AWS Config supports only one retention configuration per region in your account.
         * </p>
         * </note>
         * 
         * @param retentionConfigurationNames
         *        A list of names of retention configurations for which you want details. If you do not specify a name,
         *        AWS Config returns details for all the retention configurations for that account.</p> <note>
         *        <p>
         *        Currently, AWS Config supports only one retention configuration per region in your account.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionConfigurationNames(Collection<String> retentionConfigurationNames);

        /**
         * <p>
         * A list of names of retention configurations for which you want details. If you do not specify a name, AWS
         * Config returns details for all the retention configurations for that account.
         * </p>
         * <note>
         * <p>
         * Currently, AWS Config supports only one retention configuration per region in your account.
         * </p>
         * </note>
         * 
         * @param retentionConfigurationNames
         *        A list of names of retention configurations for which you want details. If you do not specify a name,
         *        AWS Config returns details for all the retention configurations for that account.</p> <note>
         *        <p>
         *        Currently, AWS Config supports only one retention configuration per region in your account.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionConfigurationNames(String... retentionConfigurationNames);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> retentionConfigurationNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRetentionConfigurationsRequest model) {
            super(model);
            retentionConfigurationNames(model.retentionConfigurationNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getRetentionConfigurationNames() {
            return retentionConfigurationNames;
        }

        @Override
        public final Builder retentionConfigurationNames(Collection<String> retentionConfigurationNames) {
            this.retentionConfigurationNames = RetentionConfigurationNameListCopier.copy(retentionConfigurationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionConfigurationNames(String... retentionConfigurationNames) {
            retentionConfigurationNames(Arrays.asList(retentionConfigurationNames));
            return this;
        }

        public final void setRetentionConfigurationNames(Collection<String> retentionConfigurationNames) {
            this.retentionConfigurationNames = RetentionConfigurationNameListCopier.copy(retentionConfigurationNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRetentionConfigurationsRequest build() {
            return new DescribeRetentionConfigurationsRequest(this);
        }
    }
}
