/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.EvaluationResultIdentifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Uniquely identifies an evaluation result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationResultIdentifier implements StructuredPojo,
        ToCopyableBuilder<EvaluationResultIdentifier.Builder, EvaluationResultIdentifier> {
    private final EvaluationResultQualifier evaluationResultQualifier;

    private final Instant orderingTimestamp;

    private EvaluationResultIdentifier(BuilderImpl builder) {
        this.evaluationResultQualifier = builder.evaluationResultQualifier;
        this.orderingTimestamp = builder.orderingTimestamp;
    }

    /**
     * <p>
     * Identifies an AWS Config rule used to evaluate an AWS resource, and provides the type and ID of the evaluated
     * resource.
     * </p>
     * 
     * @return Identifies an AWS Config rule used to evaluate an AWS resource, and provides the type and ID of the
     *         evaluated resource.
     */
    public EvaluationResultQualifier evaluationResultQualifier() {
        return evaluationResultQualifier;
    }

    /**
     * <p>
     * The time of the event that triggered the evaluation of your AWS resources. The time can indicate when AWS Config
     * delivered a configuration item change notification, or it can indicate when AWS Config delivered the
     * configuration snapshot, depending on which event triggered the evaluation.
     * </p>
     * 
     * @return The time of the event that triggered the evaluation of your AWS resources. The time can indicate when AWS
     *         Config delivered a configuration item change notification, or it can indicate when AWS Config delivered
     *         the configuration snapshot, depending on which event triggered the evaluation.
     */
    public Instant orderingTimestamp() {
        return orderingTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResultQualifier());
        hashCode = 31 * hashCode + Objects.hashCode(orderingTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResultIdentifier)) {
            return false;
        }
        EvaluationResultIdentifier other = (EvaluationResultIdentifier) obj;
        return Objects.equals(evaluationResultQualifier(), other.evaluationResultQualifier())
                && Objects.equals(orderingTimestamp(), other.orderingTimestamp());
    }

    @Override
    public String toString() {
        return ToString.builder("EvaluationResultIdentifier").add("EvaluationResultQualifier", evaluationResultQualifier())
                .add("OrderingTimestamp", orderingTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationResultQualifier":
            return Optional.ofNullable(clazz.cast(evaluationResultQualifier()));
        case "OrderingTimestamp":
            return Optional.ofNullable(clazz.cast(orderingTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationResultIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EvaluationResultIdentifier> {
        /**
         * <p>
         * Identifies an AWS Config rule used to evaluate an AWS resource, and provides the type and ID of the evaluated
         * resource.
         * </p>
         * 
         * @param evaluationResultQualifier
         *        Identifies an AWS Config rule used to evaluate an AWS resource, and provides the type and ID of the
         *        evaluated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResultQualifier(EvaluationResultQualifier evaluationResultQualifier);

        /**
         * <p>
         * Identifies an AWS Config rule used to evaluate an AWS resource, and provides the type and ID of the evaluated
         * resource.
         * </p>
         * This is a convenience that creates an instance of the {@link EvaluationResultQualifier.Builder} avoiding the
         * need to create one manually via {@link EvaluationResultQualifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link EvaluationResultQualifier.Builder#build()} is called immediately
         * and its result is passed to {@link #evaluationResultQualifier(EvaluationResultQualifier)}.
         * 
         * @param evaluationResultQualifier
         *        a consumer that will call methods on {@link EvaluationResultQualifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationResultQualifier(EvaluationResultQualifier)
         */
        default Builder evaluationResultQualifier(Consumer<EvaluationResultQualifier.Builder> evaluationResultQualifier) {
            return evaluationResultQualifier(EvaluationResultQualifier.builder().applyMutation(evaluationResultQualifier).build());
        }

        /**
         * <p>
         * The time of the event that triggered the evaluation of your AWS resources. The time can indicate when AWS
         * Config delivered a configuration item change notification, or it can indicate when AWS Config delivered the
         * configuration snapshot, depending on which event triggered the evaluation.
         * </p>
         * 
         * @param orderingTimestamp
         *        The time of the event that triggered the evaluation of your AWS resources. The time can indicate when
         *        AWS Config delivered a configuration item change notification, or it can indicate when AWS Config
         *        delivered the configuration snapshot, depending on which event triggered the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingTimestamp(Instant orderingTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private EvaluationResultQualifier evaluationResultQualifier;

        private Instant orderingTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResultIdentifier model) {
            evaluationResultQualifier(model.evaluationResultQualifier);
            orderingTimestamp(model.orderingTimestamp);
        }

        public final EvaluationResultQualifier.Builder getEvaluationResultQualifier() {
            return evaluationResultQualifier != null ? evaluationResultQualifier.toBuilder() : null;
        }

        @Override
        public final Builder evaluationResultQualifier(EvaluationResultQualifier evaluationResultQualifier) {
            this.evaluationResultQualifier = evaluationResultQualifier;
            return this;
        }

        public final void setEvaluationResultQualifier(EvaluationResultQualifier.BuilderImpl evaluationResultQualifier) {
            this.evaluationResultQualifier = evaluationResultQualifier != null ? evaluationResultQualifier.build() : null;
        }

        public final Instant getOrderingTimestamp() {
            return orderingTimestamp;
        }

        @Override
        public final Builder orderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
            return this;
        }

        public final void setOrderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
        }

        @Override
        public EvaluationResultIdentifier build() {
            return new EvaluationResultIdentifier(this);
        }
    }
}
