/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAggregateComplianceDetailsByConfigRuleRequest extends ConfigRequest
        implements
        ToCopyableBuilder<GetAggregateComplianceDetailsByConfigRuleRequest.Builder, GetAggregateComplianceDetailsByConfigRuleRequest> {
    private final String configurationAggregatorName;

    private final String configRuleName;

    private final String accountId;

    private final String awsRegion;

    private final String complianceType;

    private final Integer limit;

    private final String nextToken;

    private GetAggregateComplianceDetailsByConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.configRuleName = builder.configRuleName;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
        this.complianceType = builder.complianceType;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the configuration aggregator.
     * </p>
     * 
     * @return The name of the configuration aggregator.
     */
    public String configurationAggregatorName() {
        return configurationAggregatorName;
    }

    /**
     * <p>
     * The name of the AWS Config rule for which you want compliance information.
     * </p>
     * 
     * @return The name of the AWS Config rule for which you want compliance information.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The 12-digit account ID of the source account.
     * </p>
     * 
     * @return The 12-digit account ID of the source account.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The source region from where the data is aggregated.
     * </p>
     * 
     * @return The source region from where the data is aggregated.
     */
    public String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The resource compliance status.
     * </p>
     * <note>
     * <p>
     * For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, AWS Config supports only the
     * <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
     * <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The resource compliance status.</p> <note>
     *         <p>
     *         For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, AWS Config supports only
     *         the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
     *         <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.
     *         </p>
     * @see ComplianceType
     */
    public ComplianceType complianceType() {
        return ComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * The resource compliance status.
     * </p>
     * <note>
     * <p>
     * For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, AWS Config supports only the
     * <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
     * <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The resource compliance status.</p> <note>
     *         <p>
     *         For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, AWS Config supports only
     *         the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
     *         <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.
     *         </p>
     * @see ComplianceType
     */
    public String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * <p>
     * The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a number
     * greater than 100. If you specify 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a
     *         number greater than 100. If you specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateComplianceDetailsByConfigRuleRequest)) {
            return false;
        }
        GetAggregateComplianceDetailsByConfigRuleRequest other = (GetAggregateComplianceDetailsByConfigRuleRequest) obj;
        return Objects.equals(configurationAggregatorName(), other.configurationAggregatorName())
                && Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetAggregateComplianceDetailsByConfigRuleRequest")
                .add("ConfigurationAggregatorName", configurationAggregatorName()).add("ConfigRuleName", configRuleName())
                .add("AccountId", accountId()).add("AwsRegion", awsRegion()).add("ComplianceType", complianceTypeAsString())
                .add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorName":
            return Optional.ofNullable(clazz.cast(configurationAggregatorName()));
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder,
            CopyableBuilder<Builder, GetAggregateComplianceDetailsByConfigRuleRequest> {
        /**
         * <p>
         * The name of the configuration aggregator.
         * </p>
         * 
         * @param configurationAggregatorName
         *        The name of the configuration aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorName(String configurationAggregatorName);

        /**
         * <p>
         * The name of the AWS Config rule for which you want compliance information.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule for which you want compliance information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The 12-digit account ID of the source account.
         * </p>
         * 
         * @param accountId
         *        The 12-digit account ID of the source account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The source region from where the data is aggregated.
         * </p>
         * 
         * @param awsRegion
         *        The source region from where the data is aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The resource compliance status.
         * </p>
         * <note>
         * <p>
         * For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, AWS Config supports only the
         * <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
         * <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.
         * </p>
         * </note>
         * 
         * @param complianceType
         *        The resource compliance status.</p> <note>
         *        <p>
         *        For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, AWS Config supports
         *        only the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
         *        <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.
         *        </p>
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The resource compliance status.
         * </p>
         * <note>
         * <p>
         * For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, AWS Config supports only the
         * <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
         * <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.
         * </p>
         * </note>
         * 
         * @param complianceType
         *        The resource compliance status.</p> <note>
         *        <p>
         *        For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, AWS Config supports
         *        only the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
         *        <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.
         *        </p>
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a
         * number greater than 100. If you specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of evaluation results returned on each page. The default is 50. You cannot specify
         *        a number greater than 100. If you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationAggregatorName;

        private String configRuleName;

        private String accountId;

        private String awsRegion;

        private String complianceType;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateComplianceDetailsByConfigRuleRequest model) {
            super(model);
            configurationAggregatorName(model.configurationAggregatorName);
            configRuleName(model.configRuleName);
            accountId(model.accountId);
            awsRegion(model.awsRegion);
            complianceType(model.complianceType);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getConfigurationAggregatorName() {
            return configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAggregateComplianceDetailsByConfigRuleRequest build() {
            return new GetAggregateComplianceDetailsByConfigRuleRequest(this);
        }
    }
}
