/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAggregateComplianceDetailsByConfigRuleResponse extends ConfigResponse
        implements
        ToCopyableBuilder<GetAggregateComplianceDetailsByConfigRuleResponse.Builder, GetAggregateComplianceDetailsByConfigRuleResponse> {
    private final List<AggregateEvaluationResult> aggregateEvaluationResults;

    private final String nextToken;

    private GetAggregateComplianceDetailsByConfigRuleResponse(BuilderImpl builder) {
        super(builder);
        this.aggregateEvaluationResults = builder.aggregateEvaluationResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Returns an AggregateEvaluationResults object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns an AggregateEvaluationResults object.
     */
    public List<AggregateEvaluationResult> aggregateEvaluationResults() {
        return aggregateEvaluationResults;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregateEvaluationResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateComplianceDetailsByConfigRuleResponse)) {
            return false;
        }
        GetAggregateComplianceDetailsByConfigRuleResponse other = (GetAggregateComplianceDetailsByConfigRuleResponse) obj;
        return Objects.equals(aggregateEvaluationResults(), other.aggregateEvaluationResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetAggregateComplianceDetailsByConfigRuleResponse")
                .add("AggregateEvaluationResults", aggregateEvaluationResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregateEvaluationResults":
            return Optional.ofNullable(clazz.cast(aggregateEvaluationResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder,
            CopyableBuilder<Builder, GetAggregateComplianceDetailsByConfigRuleResponse> {
        /**
         * <p>
         * Returns an AggregateEvaluationResults object.
         * </p>
         * 
         * @param aggregateEvaluationResults
         *        Returns an AggregateEvaluationResults object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateEvaluationResults(Collection<AggregateEvaluationResult> aggregateEvaluationResults);

        /**
         * <p>
         * Returns an AggregateEvaluationResults object.
         * </p>
         * 
         * @param aggregateEvaluationResults
         *        Returns an AggregateEvaluationResults object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateEvaluationResults(AggregateEvaluationResult... aggregateEvaluationResults);

        /**
         * <p>
         * Returns an AggregateEvaluationResults object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AggregateEvaluationResult>.Builder}
         * avoiding the need to create one manually via {@link List<AggregateEvaluationResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregateEvaluationResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregateEvaluationResults(List<AggregateEvaluationResult>)}.
         * 
         * @param aggregateEvaluationResults
         *        a consumer that will call methods on {@link List<AggregateEvaluationResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregateEvaluationResults(List<AggregateEvaluationResult>)
         */
        Builder aggregateEvaluationResults(Consumer<AggregateEvaluationResult.Builder>... aggregateEvaluationResults);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<AggregateEvaluationResult> aggregateEvaluationResults = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateComplianceDetailsByConfigRuleResponse model) {
            super(model);
            aggregateEvaluationResults(model.aggregateEvaluationResults);
            nextToken(model.nextToken);
        }

        public final Collection<AggregateEvaluationResult.Builder> getAggregateEvaluationResults() {
            return aggregateEvaluationResults != null ? aggregateEvaluationResults.stream()
                    .map(AggregateEvaluationResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregateEvaluationResults(Collection<AggregateEvaluationResult> aggregateEvaluationResults) {
            this.aggregateEvaluationResults = AggregateEvaluationResultListCopier.copy(aggregateEvaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateEvaluationResults(AggregateEvaluationResult... aggregateEvaluationResults) {
            aggregateEvaluationResults(Arrays.asList(aggregateEvaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateEvaluationResults(Consumer<AggregateEvaluationResult.Builder>... aggregateEvaluationResults) {
            aggregateEvaluationResults(Stream.of(aggregateEvaluationResults)
                    .map(c -> AggregateEvaluationResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregateEvaluationResults(
                Collection<AggregateEvaluationResult.BuilderImpl> aggregateEvaluationResults) {
            this.aggregateEvaluationResults = AggregateEvaluationResultListCopier.copyFromBuilder(aggregateEvaluationResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetAggregateComplianceDetailsByConfigRuleResponse build() {
            return new GetAggregateComplianceDetailsByConfigRuleResponse(this);
        }
    }
}
