/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.PendingAggregationRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the account ID and region of an aggregator account that is requesting authorization but is
 * not yet authorized.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingAggregationRequest implements StructuredPojo,
        ToCopyableBuilder<PendingAggregationRequest.Builder, PendingAggregationRequest> {
    private final String requesterAccountId;

    private final String requesterAwsRegion;

    private PendingAggregationRequest(BuilderImpl builder) {
        this.requesterAccountId = builder.requesterAccountId;
        this.requesterAwsRegion = builder.requesterAwsRegion;
    }

    /**
     * <p>
     * The 12-digit account ID of the account requesting to aggregate data.
     * </p>
     * 
     * @return The 12-digit account ID of the account requesting to aggregate data.
     */
    public String requesterAccountId() {
        return requesterAccountId;
    }

    /**
     * <p>
     * The region requesting to aggregate data.
     * </p>
     * 
     * @return The region requesting to aggregate data.
     */
    public String requesterAwsRegion() {
        return requesterAwsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterAwsRegion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingAggregationRequest)) {
            return false;
        }
        PendingAggregationRequest other = (PendingAggregationRequest) obj;
        return Objects.equals(requesterAccountId(), other.requesterAccountId())
                && Objects.equals(requesterAwsRegion(), other.requesterAwsRegion());
    }

    @Override
    public String toString() {
        return ToString.builder("PendingAggregationRequest").add("RequesterAccountId", requesterAccountId())
                .add("RequesterAwsRegion", requesterAwsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequesterAccountId":
            return Optional.ofNullable(clazz.cast(requesterAccountId()));
        case "RequesterAwsRegion":
            return Optional.ofNullable(clazz.cast(requesterAwsRegion()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PendingAggregationRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PendingAggregationRequest> {
        /**
         * <p>
         * The 12-digit account ID of the account requesting to aggregate data.
         * </p>
         * 
         * @param requesterAccountId
         *        The 12-digit account ID of the account requesting to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterAccountId(String requesterAccountId);

        /**
         * <p>
         * The region requesting to aggregate data.
         * </p>
         * 
         * @param requesterAwsRegion
         *        The region requesting to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterAwsRegion(String requesterAwsRegion);
    }

    static final class BuilderImpl implements Builder {
        private String requesterAccountId;

        private String requesterAwsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingAggregationRequest model) {
            requesterAccountId(model.requesterAccountId);
            requesterAwsRegion(model.requesterAwsRegion);
        }

        public final String getRequesterAccountId() {
            return requesterAccountId;
        }

        @Override
        public final Builder requesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
            return this;
        }

        public final void setRequesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
        }

        public final String getRequesterAwsRegion() {
            return requesterAwsRegion;
        }

        @Override
        public final Builder requesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
            return this;
        }

        public final void setRequesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
        }

        @Override
        public PendingAggregationRequest build() {
            return new PendingAggregationRequest(this);
        }
    }
}
