/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAggregationAuthorizationResponse extends ConfigResponse implements
        ToCopyableBuilder<PutAggregationAuthorizationResponse.Builder, PutAggregationAuthorizationResponse> {
    private final AggregationAuthorization aggregationAuthorization;

    private PutAggregationAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.aggregationAuthorization = builder.aggregationAuthorization;
    }

    /**
     * <p>
     * Returns an AggregationAuthorization object.
     * </p>
     * 
     * @return Returns an AggregationAuthorization object.
     */
    public AggregationAuthorization aggregationAuthorization() {
        return aggregationAuthorization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAuthorization());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAggregationAuthorizationResponse)) {
            return false;
        }
        PutAggregationAuthorizationResponse other = (PutAggregationAuthorizationResponse) obj;
        return Objects.equals(aggregationAuthorization(), other.aggregationAuthorization());
    }

    @Override
    public String toString() {
        return ToString.builder("PutAggregationAuthorizationResponse")
                .add("AggregationAuthorization", aggregationAuthorization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregationAuthorization":
            return Optional.ofNullable(clazz.cast(aggregationAuthorization()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, PutAggregationAuthorizationResponse> {
        /**
         * <p>
         * Returns an AggregationAuthorization object.
         * </p>
         * 
         * @param aggregationAuthorization
         *        Returns an AggregationAuthorization object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationAuthorization(AggregationAuthorization aggregationAuthorization);

        /**
         * <p>
         * Returns an AggregationAuthorization object.
         * </p>
         * This is a convenience that creates an instance of the {@link AggregationAuthorization.Builder} avoiding the
         * need to create one manually via {@link AggregationAuthorization#builder()}.
         *
         * When the {@link Consumer} completes, {@link AggregationAuthorization.Builder#build()} is called immediately
         * and its result is passed to {@link #aggregationAuthorization(AggregationAuthorization)}.
         * 
         * @param aggregationAuthorization
         *        a consumer that will call methods on {@link AggregationAuthorization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationAuthorization(AggregationAuthorization)
         */
        default Builder aggregationAuthorization(Consumer<AggregationAuthorization.Builder> aggregationAuthorization) {
            return aggregationAuthorization(AggregationAuthorization.builder().applyMutation(aggregationAuthorization).build());
        }
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private AggregationAuthorization aggregationAuthorization;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAggregationAuthorizationResponse model) {
            super(model);
            aggregationAuthorization(model.aggregationAuthorization);
        }

        public final AggregationAuthorization.Builder getAggregationAuthorization() {
            return aggregationAuthorization != null ? aggregationAuthorization.toBuilder() : null;
        }

        @Override
        public final Builder aggregationAuthorization(AggregationAuthorization aggregationAuthorization) {
            this.aggregationAuthorization = aggregationAuthorization;
            return this;
        }

        public final void setAggregationAuthorization(AggregationAuthorization.BuilderImpl aggregationAuthorization) {
            this.aggregationAuthorization = aggregationAuthorization != null ? aggregationAuthorization.build() : null;
        }

        @Override
        public PutAggregationAuthorizationResponse build() {
            return new PutAggregationAuthorizationResponse(this);
        }
    }
}
