/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRetentionConfigurationRequest extends ConfigRequest implements
        ToCopyableBuilder<PutRetentionConfigurationRequest.Builder, PutRetentionConfigurationRequest> {
    private final Integer retentionPeriodInDays;

    private PutRetentionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
    }

    /**
     * <p>
     * Number of days AWS Config stores your historical information.
     * </p>
     * <note>
     * <p>
     * Currently, only applicable to the configuration item history.
     * </p>
     * </note>
     * 
     * @return Number of days AWS Config stores your historical information.</p> <note>
     *         <p>
     *         Currently, only applicable to the configuration item history.
     *         </p>
     */
    public Integer retentionPeriodInDays() {
        return retentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodInDays());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRetentionConfigurationRequest)) {
            return false;
        }
        PutRetentionConfigurationRequest other = (PutRetentionConfigurationRequest) obj;
        return Objects.equals(retentionPeriodInDays(), other.retentionPeriodInDays());
    }

    @Override
    public String toString() {
        return ToString.builder("PutRetentionConfigurationRequest").add("RetentionPeriodInDays", retentionPeriodInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(retentionPeriodInDays()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, PutRetentionConfigurationRequest> {
        /**
         * <p>
         * Number of days AWS Config stores your historical information.
         * </p>
         * <note>
         * <p>
         * Currently, only applicable to the configuration item history.
         * </p>
         * </note>
         * 
         * @param retentionPeriodInDays
         *        Number of days AWS Config stores your historical information.</p> <note>
         *        <p>
         *        Currently, only applicable to the configuration item history.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodInDays(Integer retentionPeriodInDays);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private Integer retentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRetentionConfigurationRequest model) {
            super(model);
            retentionPeriodInDays(model.retentionPeriodInDays);
        }

        public final Integer getRetentionPeriodInDays() {
            return retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRetentionConfigurationRequest build() {
            return new PutRetentionConfigurationRequest(this);
        }
    }
}
