/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRetentionConfigurationResponse extends ConfigResponse implements
        ToCopyableBuilder<PutRetentionConfigurationResponse.Builder, PutRetentionConfigurationResponse> {
    private final RetentionConfiguration retentionConfiguration;

    private PutRetentionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.retentionConfiguration = builder.retentionConfiguration;
    }

    /**
     * <p>
     * Returns a retention configuration object.
     * </p>
     * 
     * @return Returns a retention configuration object.
     */
    public RetentionConfiguration retentionConfiguration() {
        return retentionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRetentionConfigurationResponse)) {
            return false;
        }
        PutRetentionConfigurationResponse other = (PutRetentionConfigurationResponse) obj;
        return Objects.equals(retentionConfiguration(), other.retentionConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("PutRetentionConfigurationResponse").add("RetentionConfiguration", retentionConfiguration())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionConfiguration":
            return Optional.ofNullable(clazz.cast(retentionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, PutRetentionConfigurationResponse> {
        /**
         * <p>
         * Returns a retention configuration object.
         * </p>
         * 
         * @param retentionConfiguration
         *        Returns a retention configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionConfiguration(RetentionConfiguration retentionConfiguration);

        /**
         * <p>
         * Returns a retention configuration object.
         * </p>
         * This is a convenience that creates an instance of the {@link RetentionConfiguration.Builder} avoiding the
         * need to create one manually via {@link RetentionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #retentionConfiguration(RetentionConfiguration)}.
         * 
         * @param retentionConfiguration
         *        a consumer that will call methods on {@link RetentionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionConfiguration(RetentionConfiguration)
         */
        default Builder retentionConfiguration(Consumer<RetentionConfiguration.Builder> retentionConfiguration) {
            return retentionConfiguration(RetentionConfiguration.builder().applyMutation(retentionConfiguration).build());
        }
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private RetentionConfiguration retentionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRetentionConfigurationResponse model) {
            super(model);
            retentionConfiguration(model.retentionConfiguration);
        }

        public final RetentionConfiguration.Builder getRetentionConfiguration() {
            return retentionConfiguration != null ? retentionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder retentionConfiguration(RetentionConfiguration retentionConfiguration) {
            this.retentionConfiguration = retentionConfiguration;
            return this;
        }

        public final void setRetentionConfiguration(RetentionConfiguration.BuilderImpl retentionConfiguration) {
            this.retentionConfiguration = retentionConfiguration != null ? retentionConfiguration.build() : null;
        }

        @Override
        public PutRetentionConfigurationResponse build() {
            return new PutRetentionConfigurationResponse(this);
        }
    }
}
