/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum ResourceType {
    AWS_EC2_CUSTOMER_GATEWAY("AWS::EC2::CustomerGateway"),

    AWS_EC2_EIP("AWS::EC2::EIP"),

    AWS_EC2_HOST("AWS::EC2::Host"),

    AWS_EC2_INSTANCE("AWS::EC2::Instance"),

    AWS_EC2_INTERNET_GATEWAY("AWS::EC2::InternetGateway"),

    AWS_EC2_NETWORK_ACL("AWS::EC2::NetworkAcl"),

    AWS_EC2_NETWORK_INTERFACE("AWS::EC2::NetworkInterface"),

    AWS_EC2_ROUTE_TABLE("AWS::EC2::RouteTable"),

    AWS_EC2_SECURITY_GROUP("AWS::EC2::SecurityGroup"),

    AWS_EC2_SUBNET("AWS::EC2::Subnet"),

    AWS_CLOUD_TRAIL_TRAIL("AWS::CloudTrail::Trail"),

    AWS_EC2_VOLUME("AWS::EC2::Volume"),

    AWS_EC2_VPC("AWS::EC2::VPC"),

    AWS_EC2_VPN_CONNECTION("AWS::EC2::VPNConnection"),

    AWS_EC2_VPN_GATEWAY("AWS::EC2::VPNGateway"),

    AWS_IAM_GROUP("AWS::IAM::Group"),

    AWS_IAM_POLICY("AWS::IAM::Policy"),

    AWS_IAM_ROLE("AWS::IAM::Role"),

    AWS_IAM_USER("AWS::IAM::User"),

    AWS_ACM_CERTIFICATE("AWS::ACM::Certificate"),

    AWS_RDS_DB_INSTANCE("AWS::RDS::DBInstance"),

    AWS_RDS_DB_SUBNET_GROUP("AWS::RDS::DBSubnetGroup"),

    AWS_RDS_DB_SECURITY_GROUP("AWS::RDS::DBSecurityGroup"),

    AWS_RDS_DB_SNAPSHOT("AWS::RDS::DBSnapshot"),

    AWS_RDS_EVENT_SUBSCRIPTION("AWS::RDS::EventSubscription"),

    AWS_ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER("AWS::ElasticLoadBalancingV2::LoadBalancer"),

    AWS_S3_BUCKET("AWS::S3::Bucket"),

    AWS_SSM_MANAGED_INSTANCE_INVENTORY("AWS::SSM::ManagedInstanceInventory"),

    AWS_REDSHIFT_CLUSTER("AWS::Redshift::Cluster"),

    AWS_REDSHIFT_CLUSTER_SNAPSHOT("AWS::Redshift::ClusterSnapshot"),

    AWS_REDSHIFT_CLUSTER_PARAMETER_GROUP("AWS::Redshift::ClusterParameterGroup"),

    AWS_REDSHIFT_CLUSTER_SECURITY_GROUP("AWS::Redshift::ClusterSecurityGroup"),

    AWS_REDSHIFT_CLUSTER_SUBNET_GROUP("AWS::Redshift::ClusterSubnetGroup"),

    AWS_REDSHIFT_EVENT_SUBSCRIPTION("AWS::Redshift::EventSubscription"),

    AWS_CLOUD_WATCH_ALARM("AWS::CloudWatch::Alarm"),

    AWS_CLOUD_FORMATION_STACK("AWS::CloudFormation::Stack"),

    AWS_DYNAMO_DB_TABLE("AWS::DynamoDB::Table"),

    AWS_AUTO_SCALING_AUTO_SCALING_GROUP("AWS::AutoScaling::AutoScalingGroup"),

    AWS_AUTO_SCALING_LAUNCH_CONFIGURATION("AWS::AutoScaling::LaunchConfiguration"),

    AWS_AUTO_SCALING_SCALING_POLICY("AWS::AutoScaling::ScalingPolicy"),

    AWS_AUTO_SCALING_SCHEDULED_ACTION("AWS::AutoScaling::ScheduledAction"),

    AWS_CODE_BUILD_PROJECT("AWS::CodeBuild::Project"),

    AWS_WAF_RATE_BASED_RULE("AWS::WAF::RateBasedRule"),

    AWS_WAF_RULE("AWS::WAF::Rule"),

    AWS_WAF_WEB_ACL("AWS::WAF::WebACL"),

    AWS_WAF_REGIONAL_RATE_BASED_RULE("AWS::WAFRegional::RateBasedRule"),

    AWS_WAF_REGIONAL_RULE("AWS::WAFRegional::Rule"),

    AWS_WAF_REGIONAL_WEB_ACL("AWS::WAFRegional::WebACL"),

    AWS_CLOUD_FRONT_DISTRIBUTION("AWS::CloudFront::Distribution"),

    AWS_CLOUD_FRONT_STREAMING_DISTRIBUTION("AWS::CloudFront::StreamingDistribution"),

    AWS_WAF_RULE_GROUP("AWS::WAF::RuleGroup"),

    AWS_WAF_REGIONAL_RULE_GROUP("AWS::WAFRegional::RuleGroup"),

    AWS_LAMBDA_FUNCTION("AWS::Lambda::Function"),

    AWS_ELASTIC_BEANSTALK_APPLICATION("AWS::ElasticBeanstalk::Application"),

    AWS_ELASTIC_BEANSTALK_APPLICATION_VERSION("AWS::ElasticBeanstalk::ApplicationVersion"),

    AWS_ELASTIC_BEANSTALK_ENVIRONMENT("AWS::ElasticBeanstalk::Environment"),

    AWS_ELASTIC_LOAD_BALANCING_LOAD_BALANCER("AWS::ElasticLoadBalancing::LoadBalancer"),

    AWS_X_RAY_ENCRYPTION_CONFIG("AWS::XRay::EncryptionConfig"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ResourceType corresponding to the value
     */
    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ResourceType}s
     */
    public static Set<ResourceType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
