/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.AggregateComplianceByConfigRule;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AggregateComplianceByConfigRule} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AggregateComplianceByConfigRuleMarshaller {
    private static final MarshallingInfo<String> CONFIGRULENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> COMPLIANCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compliance").isBinary(false).build();

    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();

    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsRegion").isBinary(false).build();

    private static final AggregateComplianceByConfigRuleMarshaller INSTANCE = new AggregateComplianceByConfigRuleMarshaller();

    private AggregateComplianceByConfigRuleMarshaller() {
    }

    public static AggregateComplianceByConfigRuleMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AggregateComplianceByConfigRule aggregateComplianceByConfigRule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(aggregateComplianceByConfigRule, "aggregateComplianceByConfigRule");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(aggregateComplianceByConfigRule.configRuleName(), CONFIGRULENAME_BINDING);
            protocolMarshaller.marshall(aggregateComplianceByConfigRule.compliance(), COMPLIANCE_BINDING);
            protocolMarshaller.marshall(aggregateComplianceByConfigRule.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(aggregateComplianceByConfigRule.awsRegion(), AWSREGION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
