/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatus;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AggregatedSourceStatus} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AggregatedSourceStatusMarshaller {
    private static final MarshallingInfo<String> SOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceId").isBinary(false).build();

    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").isBinary(false).build();

    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsRegion").isBinary(false).build();

    private static final MarshallingInfo<String> LASTUPDATESTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateStatus").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUPDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTime").isBinary(false).build();

    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastErrorCode").isBinary(false).build();

    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastErrorMessage").isBinary(false).build();

    private static final AggregatedSourceStatusMarshaller INSTANCE = new AggregatedSourceStatusMarshaller();

    private AggregatedSourceStatusMarshaller() {
    }

    public static AggregatedSourceStatusMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AggregatedSourceStatus aggregatedSourceStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(aggregatedSourceStatus, "aggregatedSourceStatus");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(aggregatedSourceStatus.sourceId(), SOURCEID_BINDING);
            protocolMarshaller.marshall(aggregatedSourceStatus.sourceTypeAsString(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall(aggregatedSourceStatus.awsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall(aggregatedSourceStatus.lastUpdateStatusAsString(), LASTUPDATESTATUS_BINDING);
            protocolMarshaller.marshall(aggregatedSourceStatus.lastUpdateTime(), LASTUPDATETIME_BINDING);
            protocolMarshaller.marshall(aggregatedSourceStatus.lastErrorCode(), LASTERRORCODE_BINDING);
            protocolMarshaller.marshall(aggregatedSourceStatus.lastErrorMessage(), LASTERRORMESSAGE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
