/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.AggregationAuthorization;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AggregationAuthorization} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AggregationAuthorizationMarshaller {
    private static final MarshallingInfo<String> AGGREGATIONAUTHORIZATIONARN_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AggregationAuthorizationArn").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHORIZEDACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthorizedAccountId").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHORIZEDAWSREGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthorizedAwsRegion").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();

    private static final AggregationAuthorizationMarshaller INSTANCE = new AggregationAuthorizationMarshaller();

    private AggregationAuthorizationMarshaller() {
    }

    public static AggregationAuthorizationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AggregationAuthorization aggregationAuthorization, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(aggregationAuthorization, "aggregationAuthorization");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(aggregationAuthorization.aggregationAuthorizationArn(),
                    AGGREGATIONAUTHORIZATIONARN_BINDING);
            protocolMarshaller.marshall(aggregationAuthorization.authorizedAccountId(), AUTHORIZEDACCOUNTID_BINDING);
            protocolMarshaller.marshall(aggregationAuthorization.authorizedAwsRegion(), AUTHORIZEDAWSREGION_BINDING);
            protocolMarshaller.marshall(aggregationAuthorization.creationTime(), CREATIONTIME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
