/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.BaseConfigurationItem;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link BaseConfigurationItem} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class BaseConfigurationItemMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();

    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").isBinary(false).build();

    private static final MarshallingInfo<Instant> CONFIGURATIONITEMCAPTURETIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("configurationItemCaptureTime").isBinary(false).build();

    private static final MarshallingInfo<String> CONFIGURATIONITEMSTATUS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("configurationItemStatus").isBinary(false).build();

    private static final MarshallingInfo<String> CONFIGURATIONSTATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationStateId").isBinary(false).build();

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").isBinary(false).build();

    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsRegion").isBinary(false).build();

    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").isBinary(false).build();

    private static final MarshallingInfo<Instant> RESOURCECREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceCreationTime").isBinary(false).build();

    private static final MarshallingInfo<String> CONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").isBinary(false).build();

    private static final MarshallingInfo<Map> SUPPLEMENTARYCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supplementaryConfiguration").isBinary(false)
            .build();

    private static final BaseConfigurationItemMarshaller INSTANCE = new BaseConfigurationItemMarshaller();

    private BaseConfigurationItemMarshaller() {
    }

    public static BaseConfigurationItemMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(BaseConfigurationItem baseConfigurationItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(baseConfigurationItem, "baseConfigurationItem");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(baseConfigurationItem.version(), VERSION_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.configurationItemCaptureTime(),
                    CONFIGURATIONITEMCAPTURETIME_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.configurationItemStatusAsString(), CONFIGURATIONITEMSTATUS_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.configurationStateId(), CONFIGURATIONSTATEID_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.arn(), ARN_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.resourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.awsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.resourceCreationTime(), RESOURCECREATIONTIME_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.configuration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.supplementaryConfiguration(), SUPPLEMENTARYCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
