/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigurationAggregator;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ConfigurationAggregator} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ConfigurationAggregatorMarshaller {
    private static final MarshallingInfo<String> CONFIGURATIONAGGREGATORNAME_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ConfigurationAggregatorName").isBinary(false).build();

    private static final MarshallingInfo<String> CONFIGURATIONAGGREGATORARN_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ConfigurationAggregatorArn").isBinary(false).build();

    private static final MarshallingInfo<List> ACCOUNTAGGREGATIONSOURCES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountAggregationSources").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ORGANIZATIONAGGREGATIONSOURCE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("OrganizationAggregationSource").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTime").isBinary(false).build();

    private static final ConfigurationAggregatorMarshaller INSTANCE = new ConfigurationAggregatorMarshaller();

    private ConfigurationAggregatorMarshaller() {
    }

    public static ConfigurationAggregatorMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ConfigurationAggregator configurationAggregator, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(configurationAggregator, "configurationAggregator");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(configurationAggregator.configurationAggregatorName(),
                    CONFIGURATIONAGGREGATORNAME_BINDING);
            protocolMarshaller.marshall(configurationAggregator.configurationAggregatorArn(), CONFIGURATIONAGGREGATORARN_BINDING);
            protocolMarshaller.marshall(configurationAggregator.accountAggregationSources(), ACCOUNTAGGREGATIONSOURCES_BINDING);
            protocolMarshaller.marshall(configurationAggregator.organizationAggregationSource(),
                    ORGANIZATIONAGGREGATIONSOURCE_BINDING);
            protocolMarshaller.marshall(configurationAggregator.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(configurationAggregator.lastUpdatedTime(), LASTUPDATEDTIME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
