/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DescribeAggregateComplianceByConfigRulesRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DescribeAggregateComplianceByConfigRulesRequestModelMarshaller {
    private static final MarshallingInfo<String> CONFIGURATIONAGGREGATORNAME_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ConfigurationAggregatorName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> FILTERS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();

    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();

    private static final DescribeAggregateComplianceByConfigRulesRequestModelMarshaller INSTANCE = new DescribeAggregateComplianceByConfigRulesRequestModelMarshaller();

    private DescribeAggregateComplianceByConfigRulesRequestModelMarshaller() {
    }

    public static DescribeAggregateComplianceByConfigRulesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(describeAggregateComplianceByConfigRulesRequest, "describeAggregateComplianceByConfigRulesRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(describeAggregateComplianceByConfigRulesRequest.configurationAggregatorName(),
                    CONFIGURATIONAGGREGATORNAME_BINDING);
            protocolMarshaller.marshall(describeAggregateComplianceByConfigRulesRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall(describeAggregateComplianceByConfigRulesRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall(describeAggregateComplianceByConfigRulesRequest.nextToken(), NEXTTOKEN_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
